/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.serialization.DynamicOps;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.key.KeyBindAbilityManagerProperty;
import smartin.miapi.modules.abilities.key.KeyBindFacet;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.registries.MiapiRegistry;

public class ItemAbilityManager {
    private static final Map<Player, ItemStack> playerActiveItems = new WeakHashMap<Player, ItemStack>();
    private static final Map<Player, ItemStack> playerActiveItemsClient = new WeakHashMap<Player, ItemStack>();
    public static final MiapiRegistry<ItemUseAbility> useAbilityRegistry = MiapiRegistry.getInstance(ItemUseAbility.class);
    private static final AbilityHolder<?> emptyAbility = new AbilityHolder<Object>(new EmptyAbility(), new Object());
    private static final Map<ItemStack, AbilityHolder<?>> abilityMap = Collections.synchronizedMap(new WeakHashMap());
    public static final Map<Player, ResourceLocation> clientKeyBindID = new WeakHashMap<Player, ResourceLocation>();
    public static final Map<Player, ResourceLocation> serverKeyBindID = new WeakHashMap<Player, ResourceLocation>();

    public static void setup() {
        TickEvent.PLAYER_PRE.register(playerEntity -> {
            Map<Player, ItemStack> activeItems = playerActiveItems;
            if (playerEntity.level().isClientSide) {
                activeItems = playerActiveItemsClient;
            }
            ItemStack oldItem = activeItems.get(playerEntity);
            ItemStack playerItem = playerEntity.getUseItem();
            if (playerItem != null && !playerItem.equals(oldItem)) {
                activeItems.put((Player)playerEntity, playerItem);
                if (oldItem != null) {
                    AbilityHolder<?> holder = ItemAbilityManager.getAbility(oldItem);
                    holder.ability().onStoppedHolding(oldItem, playerEntity.level(), (LivingEntity)playerEntity);
                    abilityMap.remove(oldItem);
                }
            }
        });
        useAbilityRegistry.addCallback(ability -> ModularItemCache.setSupplier(AbilityMangerProperty.KEY + "_" + String.valueOf(useAbilityRegistry.findKey((ItemUseAbility)ability)), itemStack -> {
            Optional<AbilityHolder> optional = abilityMap.values().stream().filter(e -> e.ability().equals(ability)).findFirst();
            return optional.map(AbilityHolder::context).orElse(null);
        }));
        useAbilityRegistry.register(Miapi.id("empty"), emptyAbility.ability());
    }

    public static AbilityHolder<?> getEmpty() {
        return emptyAbility;
    }

    private static AbilityHolder<?> getAbility(ItemStack itemStack) {
        AbilityHolder<?> useAbility = abilityMap.get(itemStack);
        return useAbility == null ? emptyAbility : useAbility;
    }

    private static AbilityHolder<?> getAbility(ItemStack itemStack, Level world, Player player, InteractionHand hand, AbilityHitContext abilityHitContext) {
        block5: {
            ResourceLocation keybindID;
            block4: {
                keybindID = null;
                keybindID = player.level().isClientSide ? clientKeyBindID.get(player) : serverKeyBindID.get(player);
                if (keybindID != null) break block4;
                for (Map.Entry entry : ((Map)AbilityMangerProperty.property.getData(itemStack).orElse(new HashMap())).entrySet()) {
                    if (!((ItemUseAbility)entry.getKey()).allowedOnItem(itemStack, world, player, hand, abilityHitContext)) continue;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        KeyBindFacet.get(serverPlayer).reset(serverPlayer);
                    }
                    return ((ItemUseAbility)entry.getKey()).getAsHolder(entry.getValue());
                }
                break block5;
            }
            Map map = KeyBindAbilityManagerProperty.property.getData(itemStack).orElse(new HashMap());
            Map abilities = (Map)map.get(keybindID);
            if (abilities == null) break block5;
            for (Map.Entry entry : abilities.entrySet()) {
                ServerPlayer serverPlayer;
                if (!((ItemUseAbility)entry.getKey()).allowedOnItem(itemStack, world, player, hand, abilityHitContext)) continue;
                if (player instanceof ServerPlayer && KeyBindFacet.get(serverPlayer = (ServerPlayer)player) != null) {
                    KeyBindFacet.get(serverPlayer).set(keybindID, serverPlayer);
                }
                return ((ItemUseAbility)entry.getKey()).getAsHolder(entry.getValue());
            }
        }
        return emptyAbility;
    }

    public static UseAnim getUseAction(ItemStack itemStack, Supplier<UseAnim> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.ability().getUseAction(itemStack);
    }

    public static int getMaxUseTime(ItemStack itemStack, LivingEntity livingEntity, Supplier<Integer> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.ability().getMaxUseTime(itemStack, livingEntity);
    }

    public static InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, Supplier<InteractionResultHolder<ItemStack>> getItem) {
        ItemStack itemStack = user.getItemInHand(hand);
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack, world, user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return null;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return null;
            }
        });
        abilityMap.put(itemStack, ability);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.ability().use(world, user, hand);
    }

    public static ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user, Supplier<ItemStack> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            abilityMap.remove(stack);
            return getItem.get();
        }
        ItemStack itemStack = ability.ability().finishUsing(stack, world, user);
        abilityMap.remove(stack);
        return itemStack;
    }

    public static void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            getItem.run();
            return;
        }
        ability.ability().onStoppedUsing(stack, world, user, remainingUseTicks);
        ItemUseAbility<?> itemUseAbility = ability.ability();
        if (itemUseAbility instanceof ItemUseDefaultCooldownAbility) {
            ItemUseDefaultCooldownAbility itemUseDefaultCooldownAbility = (ItemUseDefaultCooldownAbility)itemUseAbility;
            itemUseDefaultCooldownAbility.afterStopAbility(stack, world, user, remainingUseTicks);
        }
        abilityMap.remove(stack);
    }

    public static void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            abilityMap.remove(stack);
            getItem.run();
            return;
        }
        ability.ability().usageTick(world, user, stack, remainingUseTicks);
    }

    public static boolean useOnRelease(ItemStack stack, Supplier<Boolean> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            abilityMap.remove(stack);
            return getItem.get();
        }
        return ability.ability().useOnRelease(stack);
    }

    public static InteractionResult useOnEntity(ItemStack stack, Player user, final LivingEntity entity, InteractionHand hand, Supplier<InteractionResult> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack, user.level(), user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return null;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return entity;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        abilityMap.put(stack, ability);
        return ItemAbilityManager.getAbility(stack).ability().useOnEntity(stack, user, entity, hand);
    }

    public static InteractionResult useOnBlock(final UseOnContext context, Supplier<InteractionResult> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(context.getItemInHand(), context.getLevel(), context.getPlayer(), context.getHand(), new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return context;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return null;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        abilityMap.put(context.getItemInHand(), ability);
        if (Platform.isForgeLike()) {
            InteractionResult result = ItemAbilityManager.getAbility(context.getItemInHand()).ability().useOnBlock(context);
            if (result.equals((Object)InteractionResult.PASS)) {
                return getItem.get();
            }
            return result;
        }
        return ItemAbilityManager.getAbility(context.getItemInHand()).ability().useOnBlock(context);
    }

    public record AbilityHolder<T>(ItemUseAbility<T> ability, T context) {
        public AbilityHolder(Object context, ItemUseAbility<T> ability) {
            this(ability, ability.castTo(context));
        }
    }

    public static interface AbilityHitContext {
        @Nullable
        public UseOnContext hitResult();

        @Nullable
        public Entity hitEntity();
    }

    static class EmptyAbility
    implements ItemUseAbility {
        EmptyAbility() {
        }

        @Override
        public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, AbilityHitContext abilityHitContext) {
            return true;
        }

        @Override
        public UseAnim getUseAction(ItemStack itemStack) {
            return UseAnim.NONE;
        }

        @Override
        public int getMaxUseTime(ItemStack itemStack, LivingEntity entity) {
            return 0;
        }

        @Override
        public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }

        public Object decode(DynamicOps ops, Object prefix) {
            return null;
        }

        public Object getDefaultContext() {
            return null;
        }
    }
}

