/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.serialization.DynamicOps;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public interface ItemUseAbility<T>
extends MergeAble<T> {
    public boolean allowedOnItem(ItemStack var1, Level var2, Player var3, InteractionHand var4, ItemAbilityManager.AbilityHitContext var5);

    public UseAnim getUseAction(ItemStack var1);

    public int getMaxUseTime(ItemStack var1, LivingEntity var2);

    public InteractionResultHolder<ItemStack> use(Level var1, Player var2, InteractionHand var3);

    default public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        return stack;
    }

    default public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
    }

    default public boolean useOnRelease(ItemStack itemStack) {
        return false;
    }

    default public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
    }

    default public EquipmentSlot getEquipmentSlot(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
    }

    default public InteractionResult useOnEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    default public InteractionResult useOnBlock(UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
    }

    public <K> T decode(DynamicOps<K> var1, K var2);

    default public <K> K encode(DynamicOps<K> ops, T input) {
        return null;
    }

    default public <K> K encodeObject(DynamicOps<K> ops, Object input) {
        return this.encode(ops, this.castTo(input));
    }

    default public T initialize(T data, ModuleInstance moduleInstance) {
        return data;
    }

    @Override
    default public T merge(T left, T right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    @Nullable
    public T getDefaultContext();

    @Nullable
    default public T getSpecialContext(ItemStack itemStack) {
        return this.getSpecialContext(itemStack, this.getDefaultContext());
    }

    @Nullable
    default public T getSpecialContext(ItemStack itemStack, T defaultValue) {
        return ModularItemCache.get(itemStack, AbilityMangerProperty.KEY + "_" + String.valueOf(ItemAbilityManager.useAbilityRegistry.findKey(this)), defaultValue);
    }

    default public T castTo(Object object) {
        return (T)object;
    }

    default public ItemAbilityManager.AbilityHolder<T> getAsHolder(Object context) {
        return new ItemAbilityManager.AbilityHolder<Object>(this, context);
    }
}

