/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.network.modern.ModernNetworking;

public class CacheCommands {
    public static String SEND_MATERIAL_CLIENT = "miapi_drop_cache";
    public static ResourceLocation CLEAR_CACHE_PACKET_ID = Miapi.id("clear_cache");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literal = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"clear_cache").executes(CacheCommands::executeCacheClear));
        LiteralArgumentBuilder reloadCommand = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"miapi_reload").executes(CacheCommands::executeMiapiReload));
        dispatcher.register(literal);
        dispatcher.register(reloadCommand);
        ModernNetworking.registerC2SReceiver(CLEAR_CACHE_PACKET_ID, ByteBufCodecs.fromCodecWithRegistries(Miapi.FIXED_BOOL_CODEC), (data, player, registryAccess) -> ModularItemCache.discardCache());
        ModernNetworking.registerS2CReceiver(CLEAR_CACHE_PACKET_ID, ByteBufCodecs.fromCodecWithRegistries(Miapi.FIXED_BOOL_CODEC), (data, player, registryAccess) -> ModularItemCache.discardCache());
    }

    private static int executeCacheClear(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Clearing all miapi Caches"), false);
        CacheCommands.clearCacheAllClients(((CommandSourceStack)context.getSource()).getServer());
        ModularItemCache.discardCache();
        return 1;
    }

    public static void clearCacheAllClients(MinecraftServer server) {
        server.getPlayerList().getPlayers().forEach(CacheCommands::reloadPlayerFromServer);
    }

    public static void reloadPlayerFromServer(ServerPlayer p) {
        ModernNetworking.sendToPlayer(CLEAR_CACHE_PACKET_ID, (Player)p, ByteBufCodecs.fromCodecWithRegistries(Miapi.FIXED_BOOL_CODEC), true);
    }

    private static int executeMiapiReload(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"starting reload"), false);
        CacheCommands.triggerServerReload();
        return 1;
    }

    public static void triggerServerReload() {
        ++ReloadEvents.reloadCounter;
        MiapiEvents.ReloadEventData data = new MiapiEvents.ReloadEventData();
        data.data = new LinkedHashMap<ResourceLocation, String>();
        data.data.putAll(ReloadEvents.RAW_DATA_PACKS);
        ((MiapiEvents.ReloadEvent)MiapiEvents.ADJUST_RAW_DATA.invoker()).onReload(data);
        ReloadEvents.START.fireEvent(false, (RegistryAccess)Miapi.server.registryAccess());
        ReloadEvents.DataPackLoader.trigger(data.data);
        ReloadEvents.MAIN.fireEvent(false, (RegistryAccess)Miapi.server.registryAccess());
        ReloadEvents.END.fireEvent(false, (RegistryAccess)Miapi.server.registryAccess());
        ReloadEvents.reloadCounter = 0;
        Miapi.server.getPlayerList().getPlayers().forEach(ReloadEvents::triggerReloadOnClient);
        ((MiapiEvents.ReloadEventPost)MiapiEvents.POST_HOT_RELOAD.invoker()).onReload();
    }

    static ArgumentType<String> getArgumentType() {
        return new ArgumentType<String>(){

            public String parse(StringReader reader) {
                return reader.getRead();
            }

            public Collection<String> getExamples() {
                return CacheCommands.getMaterialOptions();
            }
        };
    }

    private static List<String> getMaterialOptions() {
        return MaterialProperty.MATERIAL_REGISTRY.getFlatMap().keySet().stream().map(ResourceLocation::toString).toList();
    }
}

