/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.conditions.TrueCondition;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class ConditionManager {
    public static Map<ResourceLocation, Codec<? extends ModuleCondition>> CONDITION_REGISTRY = new ConcurrentHashMap<ResourceLocation, Codec<? extends ModuleCondition>>();
    public static ContextManager<ModuleInstance> MODULE_CONDITION_CONTEXT = source -> (ModuleInstance)source;
    public static ContextManager<BlockPos> WORKBENCH_LOCATION_CONTEXT = BlockPos.class::cast;
    public static ContextManager<Player> PLAYER_CONTEXT = Player.class::cast;
    public static ContextManager<Map<ModuleProperty<?>, Object>> MODULE_PROPERTIES = source -> new HashMap((Map)source);
    public static Codec<? extends ModuleCondition> CONDITION_CODEC = new Codec<ModuleCondition>(){

        public <T> DataResult<Pair<ModuleCondition, T>> decode(DynamicOps<T> ops, T input) {
            DataResult idRestult = Codec.STRING.decode(ops, ((MapLike)ops.getMap(input).getOrThrow()).get("type"));
            if (idRestult.isError()) {
                return DataResult.error(() -> "failed to decode condition - type was missing");
            }
            Pair id = (Pair)idRestult.getOrThrow();
            Codec<? extends ModuleCondition> conditionCodec = CONDITION_REGISTRY.get(Miapi.id((String)id.getFirst()));
            if (conditionCodec == null) {
                return DataResult.error(() -> "failed to decode condition - type is not a condition:" + String.valueOf(Miapi.id((String)id.getFirst())));
            }
            DataResult result = conditionCodec.decode(ops, input);
            if (result.isSuccess()) {
                return DataResult.success((Object)new Pair((Object)((ModuleCondition)((Pair)result.getOrThrow()).getFirst()), ((Pair)result.getOrThrow()).getSecond()));
            }
            return DataResult.error(() -> "failed to decode condition " + ((DataResult.Error)result.error().get()).message());
        }

        public <T> DataResult<T> encode(ModuleCondition input, DynamicOps<T> ops, T prefix) {
            return DataResult.error(() -> "conditions cannot be encoded. This feature might be added later");
        }
    };
    public static Codec<ModuleCondition> CONDITION_CODEC_DIRECT = new Codec<ModuleCondition>(){

        public <T> DataResult<T> encode(ModuleCondition input, DynamicOps<T> ops, T prefix) {
            return CONDITION_CODEC.encode(this.cast(input), ops, prefix);
        }

        public <T extends ModuleCondition> T cast(ModuleCondition condition) {
            return (T)condition;
        }

        public <T> DataResult<Pair<ModuleCondition, T>> decode(DynamicOps<T> ops, T input) {
            DataResult firstResult = CONDITION_CODEC.decode(ops, input);
            if (firstResult.isError()) {
                return DataResult.error(() -> ((DataResult.Error)firstResult.error().get()).message());
            }
            Pair pair = (Pair)firstResult.getOrThrow();
            return DataResult.success((Object)new Pair((Object)((ModuleCondition)pair.getFirst()), pair.getSecond()));
        }
    };

    public static void setup() {
    }

    public static ModuleCondition get(JsonElement element) {
        try {
            return (ModuleCondition)CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow();
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("issue during condition decoding " + String.valueOf(e));
            Miapi.LOGGER.error(String.valueOf(element));
            e.fillInStackTrace();
            return new TrueCondition();
        }
    }

    public static ConditionContext fullContext(ModuleInstance moduleInstance, BlockPos pos, Player player, Map<ModuleProperty<?>, Object> properties) {
        ConditionContext context = new ConditionContext();
        context.setContext(MODULE_CONDITION_CONTEXT, moduleInstance);
        context.setContext(WORKBENCH_LOCATION_CONTEXT, pos);
        context.setContext(PLAYER_CONTEXT, player);
        context.setContext(MODULE_PROPERTIES, properties);
        return context;
    }

    public static ConditionContext playerContext(ModuleInstance moduleInstance, Player player, Map<ModuleProperty<?>, Object> properties) {
        ConditionContext context = new ConditionContext();
        context.setContext(MODULE_CONDITION_CONTEXT, moduleInstance);
        context.setContext(PLAYER_CONTEXT, player);
        context.setContext(MODULE_PROPERTIES, properties);
        return context;
    }

    public static ConditionContext moduleContext(ModuleInstance moduleInstance, Map<ModuleProperty<?>, Object> properties) {
        ConditionContext context = new ConditionContext();
        context.setContext(MODULE_CONDITION_CONTEXT, moduleInstance);
        context.setContext(MODULE_PROPERTIES, properties);
        return context;
    }

    public static class ConditionContext {
        Map<ContextManager<?>, Object> context = new HashMap();
        public List<Component> failReasons = new ArrayList<Component>();

        public ConditionContext copy() {
            ConditionContext copy = new ConditionContext();
            this.context.forEach((contextHolder, contextInfo) -> this.context.put((ContextManager<?>)contextHolder, contextHolder.copy(contextInfo)));
            return copy;
        }

        public <T> void setContext(ContextManager<T> contextManger, T actualData) {
            this.context.put(contextManger, actualData);
        }

        public <T> Optional<T> getContext(ContextManager<T> contextManger) {
            return Optional.ofNullable(this.context.get(contextManger));
        }
    }

    public static interface ContextManager<T> {
        public T copy(Object var1);
    }
}

