/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;

public record ItemInInventoryCondition(Ingredient item, MinMaxBounds.Ints count, Component error) implements ModuleCondition
{
    public static Codec<ItemInInventoryCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("material").forGetter(condition -> condition.item), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("count", (Object)MinMaxBounds.Ints.atLeast((int)1)).forGetter(condition -> condition.count), (App)ComponentSerialization.CODEC.optionalFieldOf("error", (Object)Component.literal((String)"Unavailable.")).forGetter(condition -> condition.error)).apply((Applicative)instance, ItemInInventoryCondition::new));

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        Optional<Player> playerOptional = conditionContext.getContext(ConditionManager.PLAYER_CONTEXT);
        if (playerOptional.isPresent()) {
            Player player = playerOptional.get();
            List<Component> reasons = conditionContext.failReasons;
            if (player != null && this.count.matches(this.getCount((Container)player.getInventory(), this.item))) {
                return true;
            }
            int min = this.count.min().orElse(0);
            Integer max = this.count.max().orElse(0);
            String ingredientName = "";
            if (this.item.getItems() != null && this.item.getItems().length > 1) {
                ingredientName = Component.translatable((String)this.item.getItems()[0].getItem().getDescriptionId()).toString();
            }
            MutableComponent text = max != null ? Component.translatable((String)"miapi.condition.item_in_inventory.error.specific", (Object[])new Object[]{min, max, ingredientName}) : Component.translatable((String)"miapi.condition.item_in_inventory.error.no_max", (Object[])new Object[]{min, ingredientName});
            reasons.add((Component)text);
        }
        return false;
    }

    public int getCount(Container inventory, Ingredient ingredient) {
        int found = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!ingredient.test(inventory.getItem(i))) continue;
            found += inventory.getItem(i).getCount();
        }
        return found;
    }
}

