/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;

public class MaterialGroupCondition
implements ModuleCondition {
    public static Codec<MaterialGroupCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("material_group").forGetter(condition -> condition.materialGroup), (App)ComponentSerialization.CODEC.optionalFieldOf("error", (Object)Component.translatable((String)"miapi.condition.material.error")).forGetter(condition -> condition.error)).apply((Applicative)instance, MaterialGroupCondition::new));
    public String materialGroup;
    public Component error;

    public MaterialGroupCondition(String materialKey, Component error) {
        this.materialGroup = materialKey;
        this.error = error;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        Optional<ModuleInstance> moduleOptional = conditionContext.getContext(ConditionManager.MODULE_CONDITION_CONTEXT);
        if (moduleOptional.isPresent()) {
            Material material;
            ModuleInstance moduleInstance = moduleOptional.get();
            List<Component> reasons = conditionContext.failReasons;
            Material material2 = MaterialProperty.getMaterial(moduleInstance);
            if (material2 instanceof Material && (material = material2).getGroups().contains(this.materialGroup)) {
                return true;
            }
            reasons.add(this.error);
        }
        conditionContext.failReasons.add((Component)Component.translatable((String)"miapi.condition.material.error"));
        return false;
    }
}

