/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.registries.RegistryInventory;

public class ModuleTypeCondition
implements ModuleCondition {
    public static Codec<ModuleTypeCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("module").forGetter(condition -> condition.module.id()), (App)ComponentSerialization.CODEC.optionalFieldOf("error", (Object)Component.translatable((String)"miapi.condition.material.error")).forGetter(condition -> condition.error)).apply((Applicative)instance, ModuleTypeCondition::new));
    @Nullable
    public ItemModule module;
    public Component error;

    public ModuleTypeCondition(ResourceLocation moduleID, Component error) {
        this.module = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(moduleID);
        this.error = error;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        Optional<ModuleInstance> optional = conditionContext.getContext(ConditionManager.MODULE_CONDITION_CONTEXT);
        if (optional.isPresent() && this.module != null) {
            ModuleInstance moduleInstance = optional.get();
            return moduleInstance.module.equals(this.module);
        }
        return false;
    }
}

