/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.CreateItemOption;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.client.gui.crafting.crafter.create_module.CreateListView;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.edit_options.ReplaceOption;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

public class CreateItemOption
implements EditOption {
    public static CreateItem selected;
    public static List<CreateItem> createAbleItems;

    @Override
    public ItemStack preview(FriendlyByteBuf buffer, EditOption.EditContext editContext) {
        String itemID = buffer.readUtf();
        String module = buffer.readUtf();
        int count = buffer.readInt();
        ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemID)));
        itemStack.setCount(count);
        ModuleInstance instance = new ModuleInstance(RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(module));
        instance.writeToItem(itemStack);
        CraftAction action = new CraftAction(buffer, editContext.getWorkbench(), editContext.getScreenHandler());
        Container inventory = editContext.getLinkedInventory();
        if (PreviewManager.currentPreviewMaterial != null) {
            inventory = new SimpleContainer(2);
            PreviewManager.currentPreviewMaterialStack.getDamageValue();
            inventory.setItem(1, PreviewManager.currentPreviewMaterialStack);
        }
        action.linkInventory(inventory, 1);
        action.setItem(itemStack);
        return action.getPreview();
    }

    @Override
    public ItemStack execute(FriendlyByteBuf buffer, EditOption.EditContext editContext) {
        String itemID = buffer.readUtf();
        String module = buffer.readUtf();
        int count = buffer.readInt();
        ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemID)));
        itemStack.setCount(count);
        ModuleInstance instance = new ModuleInstance(RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(module));
        instance.writeToItem(itemStack);
        CraftAction action = new CraftAction(buffer, editContext.getWorkbench(), editContext.getScreenHandler());
        action.setItem(itemStack);
        action.linkInventory(editContext.getLinkedInventory(), 1);
        if (action.canPerform()) {
            return action.perform();
        }
        Miapi.LOGGER.warn("Could not previewStack Craft Action. This might indicate an exploit by " + editContext.getPlayer().getStringUUID());
        return editContext.getItemstack();
    }

    @Override
    public boolean isVisible(EditOption.EditContext editContext) {
        return editContext.getItemstack().isEmpty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext editContext) {
        PreviewManager.resetCursorStack();
        ReplaceOption.unsafeEditContext = editContext;
        return new CreateListView(x, y, width, height, editContext);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 371, 165, 512, 512, "miapi.ui.edit_option.hover.create", this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static EditOption.EditContext transform(final EditOption.EditContext context, final CreateItem item) {
        return new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf craftBuffer) {
                FriendlyByteBuf packetByteBuf = Networking.createBuffer();
                packetByteBuf.writeUtf(BuiltInRegistries.ITEM.getKey((Object)selected.getItem().getItem()).toString());
                packetByteBuf.writeUtf(selected.getBaseModule().id().toString());
                packetByteBuf.writeInt(selected.getItem().getCount());
                packetByteBuf.writeBytes((ByteBuf)craftBuffer);
                context.craft(packetByteBuf);
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
                FriendlyByteBuf packetByteBuf = Networking.createBuffer();
                packetByteBuf.writeUtf(BuiltInRegistries.ITEM.getKey((Object)selected.getItem().getItem()).toString());
                packetByteBuf.writeUtf(selected.getBaseModule().id().toString());
                packetByteBuf.writeInt(selected.getItem().getCount());
                packetByteBuf.writeBytes((ByteBuf)preview);
                context.preview(packetByteBuf);
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return new SlotProperty.ModuleSlot(new ArrayList<String>());
            }

            @Override
            public ItemStack getItemstack() {
                ItemStack itemStack = item.getItem();
                this.getInstance().writeToItem(itemStack);
                return itemStack;
            }

            @Override
            @Nullable
            public ModuleInstance getInstance() {
                return new ModuleInstance(item.getBaseModule());
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return context.getPlayer();
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                return context.getWorkbench();
            }

            @Override
            public Container getLinkedInventory() {
                return context.getLinkedInventory();
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                return context.getScreenHandler();
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void addSlot(Slot slot) {
                context.addSlot(slot);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void removeSlot(Slot slot) {
                context.removeSlot(slot);
            }
        };
    }

    static {
        createAbleItems = new ArrayList<CreateItem>();
    }

    public static interface CreateItem {
        public ItemStack getItem();

        public ItemModule getBaseModule();

        public Component getName();

        default public boolean isAllowed(Player player, ModularWorkBenchEntity entity) {
            return true;
        }

        public double getPriority();
    }

    public static class JsonCreateItem
    implements CreateItem {
        public String item = "miapi:modular_item";
        public String module;
        public String translation;
        public int count = 1;
        public double priority = 0.0;

        @Override
        public ItemStack getItem() {
            ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.item)));
            itemStack.setCount(this.count);
            return itemStack;
        }

        @Override
        public ItemModule getBaseModule() {
            return RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(this.module);
        }

        @Override
        public Component getName() {
            return Component.translatable((String)this.translation);
        }

        @Override
        public double getPriority() {
            return this.priority;
        }
    }
}

