/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class ComponentProperty
extends CodecProperty<Map<ResourceLocation, JsonElement>>
implements ComponentApplyProperty,
CraftingProperty {
    public static Codec<Map<ResourceLocation, JsonElement>> CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, StatResolver.Codecs.JSONELEMENT_CODEC);
    public static final ResourceLocation KEY = Miapi.id("components");
    public static ComponentProperty property;

    public ComponentProperty() {
        super(CODEC);
        property = this;
    }

    @Override
    public void updateComponent(ItemStack itemStack, @Nullable RegistryAccess registryAccess) {
        this.getData(itemStack).ifPresent(map -> map.forEach((id, json) -> {
            try {
                DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(id);
                if (type == null) {
                    Miapi.LOGGER.error("could not find Component Type " + String.valueOf(type));
                } else {
                    this.update((DataComponentType)type, (JsonElement)json, itemStack);
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Could not apply component " + String.valueOf(id));
                Miapi.LOGGER.error("raw data " + String.valueOf(json));
            }
        }));
    }

    public <T> void update(DataComponentType<T> type, JsonElement element, ItemStack itemStack) {
        DataResult result = type.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
        if (result.isError()) {
            throw new RuntimeException("Could not decode Data Component ");
        }
        itemStack.set(type, ((Pair)result.getOrThrow()).getFirst());
    }

    @Override
    public Map<ResourceLocation, JsonElement> merge(Map<ResourceLocation, JsonElement> left, Map<ResourceLocation, JsonElement> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        this.getData(old).ifPresent(map -> map.forEach((id, json) -> {
            try {
                DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(id);
                if (type == null) {
                    Miapi.LOGGER.error("could not find Component Type " + String.valueOf(type));
                } else {
                    crafting.remove(type);
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Could not apply component " + String.valueOf(id));
                Miapi.LOGGER.error("raw data " + String.valueOf(json));
            }
        }));
        this.updateComponent(crafting, bench.getLevel().registryAccess());
        return crafting;
    }
}

