/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class DisplayNameProperty
extends CodecProperty<Component> {
    public static final ResourceLocation KEY = Miapi.id("display_name");
    public static DisplayNameProperty property;

    public DisplayNameProperty() {
        super(ComponentSerialization.CODEC);
        property = this;
        ModularItemCache.setSupplier(KEY.toString(), DisplayNameProperty::resolveDisplayText);
    }

    public static Component getDisplayText(ItemStack stack) {
        return (Component)ModularItemCache.getVisualOnlyCache(stack, KEY.toString(), Component.empty());
    }

    @Override
    public List<EditorError> validate(int line, Component component, boolean isClient) {
        String regex = "^[a-z_-]+(?:\\.[a-z._-]+)";
        String string = component.getString();
        if (Pattern.matches(regex, string) && Component.translatable((String)string).getString().equals(string)) {
            return List.of(new EditorError(line, "translation seems to be missing!", EditorError.ErrorSeverity.WARNING));
        }
        return List.of();
    }

    private static Component resolveDisplayText(ItemStack itemStack) {
        MutableComponent name = Component.translatable((String)"miapi.name.missing.nomodule");
        ModuleInstance root = ItemModule.getModules(itemStack);
        for (ModuleInstance moduleInstance : root.allSubModules()) {
            Optional componentOptional = property.getData(moduleInstance);
            if (!componentOptional.isPresent()) continue;
            Material material = MaterialProperty.getMaterial(moduleInstance);
            if (material != null) {
                Component materialTranslation = material.getTranslation();
                name = Component.translatable((String)((Component)componentOptional.get()).getString(), (Object[])new Object[]{materialTranslation});
                continue;
            }
            name = Component.translatable((String)((Component)componentOptional.get()).getString(), (Object[])new Object[]{""});
        }
        return name;
    }

    @Override
    public Component merge(Component left, Component right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }
}

