/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import com.redpxnda.nucleus.util.Color;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.client.GlintShader;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeType;

public class GlintProperty
extends CodecProperty<RainbowGlintSettings> {
    public static GlintProperty property;
    public static final ResourceLocation KEY;
    public static PrioritizedEvent<GlintGetter> GLINT_RESOLVE;
    public static SettingsControlledGlint defaultSettings;
    public static final Codec<RainbowGlintSettings> CODEC;
    public static RainbowGlintSettings vanillaLike;

    public GlintProperty() {
        super(CODEC);
        property = this;
    }

    public GlintSettings getGlintSettings(ModuleInstance instance, ItemStack stack) {
        AtomicReference<GlintSettings> reference = new AtomicReference<GlintSettings>(this.getData(instance).or(() -> {
            Optional stackData = this.getData(stack);
            if (stackData.isPresent() && ((RainbowGlintSettings)stackData.get()).isItem) {
                return stackData;
            }
            return Optional.empty();
        }).orElseGet(() -> {
            if (MiapiConfig.getClientConfig().enchantingGlint.vanillaLike) {
                return vanillaLike;
            }
            Material material = MaterialProperty.getMaterial(instance);
            if (material != null) {
                Color adjusted = new Color(material.getColor(instance, ItemDisplayContext.GUI));
                return defaultSettings.copyWithColor(this.adjustWith(adjusted, MiapiConfig.getClientConfig().enchantingGlint.materialRatioColor, GlintProperty.defaultSettings.colors));
            }
            return defaultSettings;
        }));
        ((GlintGetter)GLINT_RESOLVE.invoker()).get(stack, instance, reference);
        return reference.get();
    }

    public List<Color> adjustWith(Color adjust, float percent, Color[] previous) {
        ArrayList<Color> adjusted = new ArrayList<Color>();
        for (int i = 0; i < previous.length; ++i) {
            Color c = previous[i].copy();
            c.lerp(percent, adjust);
            adjusted.add(i, c);
        }
        return adjusted;
    }

    public static void updateConfig() {
        Color[] newColors = new Color[MiapiConfig.getClientConfig().enchantingGlint.enchantColors.size()];
        for (int i = 0; i < newColors.length; ++i) {
            newColors[i] = MiapiConfig.getClientConfig().enchantingGlint.enchantColors.get(i);
        }
        if (newColors.length == 0) {
            newColors = new Color[]{Color.WHITE};
        }
        SettingsControlledGlint glintSettings = new SettingsControlledGlint();
        glintSettings.colors = newColors;
        glintSettings.rainbowSpeed = MiapiConfig.getClientConfig().enchantingGlint.enchantingGlintSpeed;
        defaultSettings = glintSettings;
        ModularItemCache.discardCache();
    }

    @Override
    public RainbowGlintSettings merge(RainbowGlintSettings left, RainbowGlintSettings right, MergeType mergeType) {
        if (left.isItem) {
            return left;
        }
        return right;
    }

    static {
        KEY = Miapi.id("glint_settings");
        GLINT_RESOLVE = PrioritizedEvent.createLoop((Object[])new GlintGetter[0]);
        defaultSettings = new SettingsControlledGlint();
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(settings -> Float.valueOf(settings.speed)), (App)Codec.FLOAT.optionalFieldOf("rainbow_speed", (Object)Float.valueOf(1.0f)).forGetter(settings -> Float.valueOf(settings.rainbowSpeed)), (App)Codec.FLOAT.optionalFieldOf("strength", (Object)Float.valueOf(1.0f)).forGetter(settings -> Float.valueOf(settings.strength)), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("should_render_glint", (Object)false).forGetter(settings -> settings.shouldRenderGlint), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("is_item", (Object)false).forGetter(settings -> settings.isItem), (App)Codec.list(RainbowGlintSettings.COLOR_CODEC).optionalFieldOf("colors", List.of(Color.WHITE)).forGetter(settings -> Arrays.asList(settings.colors))).apply((Applicative)instance, (speed, rainbowSpeed, strength, shouldRenderGlint, item, colors) -> {
            RainbowGlintSettings settings = new RainbowGlintSettings();
            settings.speed = speed.floatValue();
            settings.rainbowSpeed = rainbowSpeed.floatValue();
            settings.strength = strength.floatValue();
            settings.shouldRenderGlint = shouldRenderGlint;
            settings.colors = colors.toArray(new Color[0]);
            settings.isItem = item;
            return settings;
        }));
        vanillaLike = new RainbowGlintSettings();
    }

    public static interface GlintSettings {
        public float getA();

        public Color getColor();

        public float getSpeed();

        default public void applySpeed() {
            GlintShader.glintShader.safeGetUniform("GlintSpeed").set(this.getSpeed());
        }

        default public void applyAlpha() {
            GlintShader.glintShader.safeGetUniform("GlintStrength").set(this.getA());
        }

        public boolean shouldRender();
    }

    public static interface GlintGetter {
        public EventResult get(ItemStack var1, ModuleInstance var2, AtomicReference<GlintSettings> var3);
    }

    public static class SettingsControlledGlint
    extends RainbowGlintSettings {
    }

    public static class RainbowGlintSettings
    implements GlintSettings {
        public static Codec<Color> COLOR_CODEC = Codec.INT.xmap(Color::new, Color::abgr);
        public float speed = 1.0f;
        public float rainbowSpeed = 1.0f;
        public float strength = 1.0f;
        public boolean shouldRenderGlint = false;
        public boolean isItem = false;
        public Color[] colors = new Color[]{new Color("A755FF80")};

        @Override
        public float getA() {
            return this.strength;
        }

        @Override
        public Color getColor() {
            long time = Util.getMillis();
            double scaledTime = (double)time / 3000.0 * (double)this.rainbowSpeed;
            int lowerColorIndex = (int)Math.floor(scaledTime %= (double)this.colors.length);
            int higherColorIndex = (lowerColorIndex + 1) % this.colors.length;
            float percent = (float)(scaledTime - Math.floor(scaledTime));
            float otherPercent = 1.0f - percent;
            Color lowerColor = this.colors[higherColorIndex];
            Color higherColor = this.colors[lowerColorIndex];
            return new Color(lowerColor.redAsFloat() * percent + higherColor.redAsFloat() * otherPercent, lowerColor.greenAsFloat() * percent + higherColor.greenAsFloat() * otherPercent, lowerColor.blueAsFloat() * percent + higherColor.blueAsFloat() * otherPercent, lowerColor.alphaAsFloat() * percent + higherColor.alphaAsFloat() * otherPercent);
        }

        @Override
        public float getSpeed() {
            return this.speed;
        }

        public float getColor(int colorNo) {
            long time = Util.getMillis();
            double scaledTime = (double)time / 3000.0 * (double)this.rainbowSpeed;
            return (float)Math.max(0.0, Math.min(1.0, Math.abs((scaledTime + (double)(colorNo * 2)) % (double)(this.colors.length * 2) - (double)this.colors.length) - (double)(this.colors.length - 2)));
        }

        @Override
        public boolean shouldRender() {
            return this.shouldRenderGlint;
        }

        public RainbowGlintSettings copyWithColor(List<Color> newColors) {
            RainbowGlintSettings copy = new RainbowGlintSettings();
            copy.speed = this.speed;
            copy.rainbowSpeed = this.rainbowSpeed;
            copy.strength = this.strength;
            copy.shouldRenderGlint = this.shouldRenderGlint;
            copy.colors = newColors.toArray(new Color[0]);
            return copy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RainbowGlintSettings that = (RainbowGlintSettings)o;
            return Float.compare(that.speed, this.speed) == 0 && Float.compare(that.rainbowSpeed, this.rainbowSpeed) == 0 && Float.compare(that.strength, this.strength) == 0 && this.shouldRenderGlint == that.shouldRenderGlint && Arrays.equals(this.colors, that.colors);
        }

        public int hashCode() {
            int result = Objects.hash(Float.valueOf(this.speed), Float.valueOf(this.rainbowSpeed), Float.valueOf(this.strength), this.shouldRenderGlint);
            result = 31 * result + Arrays.hashCode(this.colors);
            return result;
        }
    }
}

