/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class GuiStatProperty
extends CodecProperty<Map<String, GuiInfo>> {
    public static final ResourceLocation KEY = Miapi.id("gui_stat");
    public static GuiStatProperty property;
    public static Codec<Map<String, GuiInfo>> CODEC;

    public GuiStatProperty() {
        super(CODEC);
        property = this;
        if (Environment.isClient()) {
            ModularItemCache.setSupplier(KEY.toString(), GuiStatProperty::getInfoCache);
            StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(this){

                @Override
                public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                    ArrayList combined = new ArrayList();
                    LinkedHashMap<String, GuiInfo> combinedMap = new LinkedHashMap<String, GuiInfo>(GuiStatProperty.getInfo(original));
                    combinedMap.putAll(GuiStatProperty.getInfo(compareTo));
                    combinedMap.forEach((key, gui) -> {
                        JsonStatDisplay display = new JsonStatDisplay(this, itemStack -> gui.header, itemStack -> gui.description, new SingleStatDisplayDouble.StatReaderHelper(){
                            final /* synthetic */ String val$key;
                            {
                                this.val$key = string;
                            }

                            @Override
                            public double getValue(ItemStack itemStack) {
                                return GuiStatProperty.getValue(itemStack, this.val$key);
                            }

                            @Override
                            public boolean hasValue(ItemStack itemStack) {
                                return GuiStatProperty.getValue(itemStack, this.val$key) != 0.0;
                            }
                        }, gui.min.getValue(), gui.max.getValue(), (GuiInfo)gui){
                            final /* synthetic */ GuiInfo val$gui;
                            {
                                this.val$gui = guiInfo;
                                super(title, description, statReaderHelper, min, max);
                            }

                            @Override
                            public DoubleOperationResolvable getResolvable(ItemStack stack) {
                                return this.val$gui.value;
                            }
                        };
                        combined.add(display);
                    });
                    return combined;
                }
            });
        }
    }

    private static Map<String, GuiInfo> getInfoCache(ItemStack itemStack) {
        return property.getData(itemStack).orElse(new HashMap());
    }

    public static Map<String, GuiInfo> getInfo(ItemStack itemStack) {
        return ModularItemCache.getVisualOnlyCache(itemStack, KEY.toString(), new HashMap());
    }

    public static double getValue(ItemStack itemStack, String key) {
        Map<String, GuiInfo> infoMap = GuiStatProperty.getInfoCache(itemStack);
        if (infoMap.containsKey(key)) {
            return infoMap.get((Object)key).value.getValue();
        }
        return 0.0;
    }

    @Override
    public Map<String, GuiInfo> merge(Map<String, GuiInfo> left, Map<String, GuiInfo> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    @Override
    public Map<String, GuiInfo> initialize(Map<String, GuiInfo> property, ModuleInstance context) {
        HashMap initialized = new HashMap();
        property.forEach((key, value) -> initialized.put(key, value.initialize(context)));
        return super.initialize(initialized, context);
    }

    static {
        CODEC = Codec.dispatchedMap((Codec)Codec.STRING, key -> GuiInfo.CODEC);
    }

    public static class GuiInfo {
        public DoubleOperationResolvable min = new DoubleOperationResolvable(0.0);
        public DoubleOperationResolvable max = new DoubleOperationResolvable(10.0);
        public DoubleOperationResolvable value;
        public Component header;
        public Component description;
        public static final Codec<GuiInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DoubleOperationResolvable.CODEC.optionalFieldOf("min", (Object)new DoubleOperationResolvable(0.0)).forGetter(gui -> gui.min), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("max", (Object)new DoubleOperationResolvable(10.0)).forGetter(gui -> gui.max), (App)DoubleOperationResolvable.CODEC.fieldOf("value").forGetter(gui -> gui.value), (App)ComponentSerialization.CODEC.fieldOf("header").forGetter(gui -> gui.header), (App)ComponentSerialization.CODEC.optionalFieldOf("description", (Object)Component.empty()).forGetter(gui -> gui.description)).apply((Applicative)instance, GuiInfo::new));

        public GuiInfo(DoubleOperationResolvable min, DoubleOperationResolvable max, DoubleOperationResolvable value, Component header, Component description) {
            this.min = min;
            this.max = max;
            this.value = value;
            this.header = header;
            this.description = description;
        }

        public GuiInfo() {
        }

        public GuiInfo initialize(ModuleInstance moduleInstance) {
            GuiInfo init = new GuiInfo();
            init.min = this.min.initialize(moduleInstance);
            init.max = this.max.initialize(moduleInstance);
            init.value = this.value.initialize(moduleInstance);
            init.header = this.header;
            init.description = this.description;
            return init;
        }
    }
}

