/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class ItemIdProperty
extends CodecProperty<ResourceLocation>
implements CraftingProperty {
    public static final ResourceLocation KEY = Miapi.id("item_id");
    public static ItemIdProperty property;

    public ItemIdProperty() {
        super(ResourceLocation.CODEC);
        property = this;
    }

    @Override
    public boolean shouldExecuteOnCraft(ModuleInstance module, ModuleInstance root, ItemStack stack, CraftAction action) {
        return true;
    }

    @Override
    public List<EditorError> validate(int line, ResourceLocation component, boolean isClient) {
        if (!RegistryInventory.MODULAR_ITEMS.contains(component)) {
            return List.of(new EditorError(line, "Only pre-registered ItemIDs are allowed!", EditorError.ErrorSeverity.WARNING));
        }
        return List.of();
    }

    public static ItemStack changeId(ItemStack itemStack) {
        Item item;
        ModuleInstance root = ItemModule.getModules(itemStack);
        Optional optional = property.getData(itemStack);
        if (optional.isPresent() && (item = (Item)RegistryInventory.MODULAR_ITEMS.get(((ResourceLocation)optional.get()).toString())) != null) {
            root.clearCaches();
            ItemStack newStack = new ItemStack((ItemLike)item);
            newStack.applyComponents(itemStack.getComponentsPatch());
            newStack.setCount(itemStack.getCount());
            ModuleInstance newRoot = root.copy();
            newRoot.writeToItem(newStack);
            newRoot.clearCaches();
            return newStack;
        }
        return itemStack.copy();
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> dataMap) {
        return ItemIdProperty.changeId(crafting);
    }

    @Override
    public ResourceLocation merge(ResourceLocation left, ResourceLocation right, MergeType mergeType) {
        return right;
    }
}

