/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.MaterialSmithingRecipe;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.ModularItemPart;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.SmithingRecipeUtil;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class LoreProperty
extends CodecProperty<List<Holder>> {
    public static final ResourceLocation KEY = Miapi.id("item_lore");
    public static LoreProperty property;
    public static List<LoreSupplier> bottomLoreSuppliers;
    public static List<ToolTipSupplierSupplier> loreSuppliers;
    public static Map<ItemStack, Material> materialLookupTable;
    public static Map<Item, List<Component>> smithingTemplate;
    public static final Codec<Holder> CODEC_BASE;
    public static final Codec<Holder> CODEC;

    public LoreProperty() {
        super(Miapi.toListOrSimple(CODEC));
        property = this;
        loreSuppliers.add((itemStack, tooltip, context, tooltipType) -> {
            if (LoreProperty.hasModularItemDescription(itemStack)) {
                tooltip.add(LoreProperty.format((Component)Component.translatable((String)"miapi.ui.modular_item"), ChatFormatting.GRAY));
            }
            this.getHolders(itemStack).stream().filter(h -> h.position.equals("top")).forEach(holder -> tooltip.add(holder.getText()));
        });
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            try {
                smithingTemplate.clear();
                RecipeManager recipeManager = SmithingRecipeUtil.findManager(isClient);
                if (recipeManager != null) {
                    recipeManager.getAllRecipesFor(RecipeType.SMITHING).forEach(recipeHolder -> {
                        Recipe patt0$temp = recipeHolder.value();
                        if (patt0$temp instanceof MaterialSmithingRecipe) {
                            MaterialSmithingRecipe smithingRecipe = (MaterialSmithingRecipe)patt0$temp;
                            List list = smithingTemplate.computeIfAbsent(smithingRecipe.smithingTemplate.getItems()[0].getItem(), i -> new ArrayList());
                            Material ingredient = MaterialProperty.MATERIAL_REGISTRY.get(smithingRecipe.startMaterial);
                            Material target = MaterialProperty.MATERIAL_REGISTRY.get(smithingRecipe.resultMaterial);
                            if (ingredient != null && target != null) {
                                MutableComponent materialDescription = Component.translatable((String)"miapi.material_template.smithing", (Object[])new Object[]{ingredient.getTranslation().getString(), target.getTranslation().getString()}).withStyle(ChatFormatting.GRAY);
                                list.add(materialDescription);
                            }
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not setup smithing lore injection", (Throwable)e);
            }
        });
    }

    public List<Holder> getHolders(ItemStack itemStack) {
        return this.getData(itemStack).orElse(new ArrayList());
    }

    public static Component gray(Component text) {
        return LoreProperty.format(text, ChatFormatting.GRAY);
    }

    public static Component format(Component text, ChatFormatting ... formatting) {
        return (Component)text.toFlatList(Style.EMPTY.applyFormats(formatting)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectTooltipOnNonModularItems(List<Component> tooltip, ItemStack itemStack) {
        if (!Environment.isClient() && MiapiConfig.getServerConfig().other.serverLoreInjection) {
            return;
        }
        LoreProperty loreProperty = property;
        synchronized (loreProperty) {
            if (Environment.isClient()) {
                tooltip.addAll(this.addToolTipsClient(itemStack));
            } else {
                tooltip.addAll(this.addToolTipsServer(itemStack));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    List<Component> addToolTipsClient(ItemStack itemStack) {
        List<Component> description;
        Material material;
        ArrayList<Component> lines = new ArrayList<Component>();
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularMaterial && (material = materialLookupTable.computeIfAbsent(itemStack, itemStack1 -> MaterialProperty.getMaterialFromIngredient(itemStack))) != null) {
            int i = material.getGroups().size();
            if (i == 1) {
                if (MiapiConfig.getClientConfig().loreConfig.injectLoreWithoutGroup) {
                    lines.add(LoreProperty.gray((Component)Component.translatable((String)"miapi.ui.material_desc")));
                }
            } else {
                Component materialDesc = LoreProperty.gray((Component)Component.translatable((String)"miapi.ui.material_desc_alt"));
                lines.add(materialDesc);
                if (Environment.isClient()) {
                    lines.addAll(this.getAltClient(material));
                }
            }
        }
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularItem) {
            if (LoreProperty.hasModularItemDescription(itemStack)) {
                lines.add(LoreProperty.format((Component)Component.translatable((String)"miapi.ui.modular_item"), ChatFormatting.GRAY));
                return lines;
            }
            ItemStack converted = ModularItemStackConverter.getModularVersion(itemStack);
            if (LoreProperty.hasModularItemDescription(converted)) {
                lines.add(LoreProperty.format((Component)Component.translatable((String)"miapi.ui.modular_item"), ChatFormatting.GRAY));
                return lines;
            }
        }
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularTemplate && (description = smithingTemplate.get(itemStack.getItem())) != null) {
            lines.add((Component)Component.translatable((String)"miapi.material_template.smithing.header").withStyle(ChatFormatting.GRAY));
            lines.addAll(description);
        }
        return lines;
    }

    public static boolean hasModularItemDescription(ItemStack itemstack) {
        return VisualModularItem.isVisualModularItem(itemstack) && !(itemstack.getItem() instanceof ModularItemPart);
    }

    @OnlyIn(value=Dist.CLIENT)
    List<Component> getAltClient(Material material) {
        return new ArrayList<Component>(material.getDescription(Screen.hasAltDown()));
    }

    List<Component> addToolTipsServer(ItemStack itemStack) {
        ItemStack converted;
        Material material;
        ArrayList<Component> lines = new ArrayList<Component>();
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularMaterial && (material = materialLookupTable.computeIfAbsent(itemStack, itemStack1 -> MaterialProperty.getMaterialFromIngredient(itemStack))) != null) {
            int i = material.getGroups().size();
            if (i == 1) {
                if (MiapiConfig.getClientConfig().loreConfig.injectLoreWithoutGroup) {
                    lines.add(LoreProperty.gray((Component)Component.translatable((String)"miapi.ui.material_desc")));
                }
            } else {
                Component materialDesc = LoreProperty.gray((Component)Component.translatable((String)"miapi.ui.material_desc_alt"));
                lines.add(materialDesc);
            }
        }
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularItem && !ItemStack.matches((ItemStack)(converted = ModularItemStackConverter.getModularVersion(itemStack)), (ItemStack)itemStack) && LoreProperty.hasModularItemDescription(converted)) {
            lines.add(LoreProperty.format((Component)Component.translatable((String)"miapi.ui.modular_item"), ChatFormatting.GRAY));
        }
        return lines;
    }

    public static void appendLoreTop(ItemStack stack, List<Component> tooltip, Item.TooltipContext context, TooltipFlag tooltipType) {
        loreSuppliers.forEach(supplierSupplier -> supplierSupplier.getLore(stack, tooltip, context, tooltipType));
    }

    public void appendLoreBottom(List<Component> oldLore, ItemStack itemStack) {
        bottomLoreSuppliers.forEach(loreSupplier -> oldLore.addAll(loreSupplier.getLore(itemStack)));
        this.getHolders(itemStack).stream().filter(h -> h.position.equals("bottom")).forEach(holder -> oldLore.add(holder.getText()));
    }

    @Override
    public List<Holder> merge(List<Holder> left, List<Holder> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        bottomLoreSuppliers = Collections.synchronizedList(new ArrayList());
        loreSuppliers = Collections.synchronizedList(new ArrayList());
        materialLookupTable = Collections.synchronizedMap(new WeakHashMap());
        smithingTemplate = Collections.synchronizedMap(new WeakHashMap());
        CODEC_BASE = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("text").forGetter(holder -> holder.text), (App)Codec.STRING.fieldOf("position").forGetter(holder -> holder.position), (App)Codec.FLOAT.optionalFieldOf("priority", (Object)Float.valueOf(0.0f)).forGetter(holder -> Float.valueOf(holder.priority))).apply((Applicative)instance, Holder::new));
        CODEC = Codec.withAlternative(CODEC_BASE, (Codec)ComponentSerialization.CODEC.xmap(Holder::new, h -> h.text));
    }

    public static interface ToolTipSupplierSupplier {
        public void getLore(ItemStack var1, List<Component> var2, Item.TooltipContext var3, TooltipFlag var4);
    }

    public static class Holder
    implements Comparable<Holder> {
        @CodecBehavior.Optional
        public Component text;
        @CodecBehavior.Optional(value=false)
        public String position;
        @CodecBehavior.Optional
        public float priority = 0.0f;

        public Holder() {
        }

        public Holder(Component component, String position, float priority) {
            this.text = component;
            this.position = position;
            this.priority = priority;
        }

        public Holder(Component component) {
            this.text = component;
            this.position = "top";
        }

        public Component getText() {
            if (this.text != null) {
                return this.text;
            }
            return Component.empty();
        }

        @Override
        public int compareTo(@NotNull Holder o) {
            return Float.compare(this.priority, o.priority);
        }
    }

    public static interface LoreSupplier {
        public List<Component> getLore(ItemStack var1);
    }
}

