/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class LuminousLearningProperty
extends DoubleProperty {
    public static final ResourceLocation KEY = Miapi.id("luminious_learning");
    public static LuminousLearningProperty property;

    public LuminousLearningProperty() {
        super(KEY);
        property = this;
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            ItemStack tool = player.getMainHandItem();
            if (tool != null && ModularItem.isModularItem(tool)) {
                this.getValue(tool).ifPresent(value -> {
                    while (value > 0.0) {
                        if (Math.random() > 0.7 && xp != null && level instanceof ServerLevel) {
                            ServerLevel serverWorld = (ServerLevel)level;
                            ExperienceOrb.award((ServerLevel)serverWorld, (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)xp.get());
                        }
                        Double d = value;
                        value = value - 1.0;
                    }
                });
            }
            return EventResult.pass();
        });
        MiapiEvents.ADJUST_DROP_XP.register((entity, xp) -> {
            Level patt0$temp = entity.level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)patt0$temp;
                for (double value = this.getForItems(entity.getAllSlots()); value > 0.0; value -= 1.0) {
                    if (!(Math.random() > 0.7)) continue;
                    xp.add((Number)xp.getValue());
                }
            }
            return EventResult.pass();
        });
    }
}

