/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class ModuleStats
extends CodecProperty<Map<String, Double>> {
    public static final ResourceLocation KEY = Miapi.id("module_stats");
    public static ModuleStats property;
    public static Codec<Map<String, Double>> CODEC;

    public ModuleStats() {
        super(CODEC);
        property = this;
        StatResolver.registerResolver("module", new StatResolver.Resolver(){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                if (instance.module.equals(ItemModule.internal)) {
                    return 1.0;
                }
                if ("cost".equals(data)) {
                    return AllowedMaterial.getMaterialCost(instance);
                }
                return ((Map)ModuleStats.this.getData(instance).orElse(new HashMap())).getOrDefault(data, 0.0);
            }

            @Override
            public String resolveString(String data, ModuleInstance instance) {
                return null;
            }
        });
    }

    @Override
    public Map<String, Double> merge(Map<String, Double> left, Map<String, Double> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    static {
        CODEC = Codec.dispatchedMap((Codec)Codec.STRING, s -> Codec.DOUBLE);
    }
}

