/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class RepairPriority
extends DoubleProperty {
    public static RepairPriority property;
    public static final ResourceLocation KEY;

    public RepairPriority() {
        super(KEY);
        property = this;
        this.allowVisualOnly = true;
        ModularItemCache.setSupplier(String.valueOf(KEY) + "_materials", this::getRepairMaterialsPrivate);
    }

    public List<Material> getRepairMaterials(ItemStack itemStack) {
        return ModularItemCache.getVisualOnlyCache(itemStack, String.valueOf(KEY) + "_materials", new ArrayList());
    }

    public static double getRepairValue(ItemStack tool, ItemStack material) {
        double highestValue = 0.0;
        for (Material material1 : property.getRepairMaterials(tool)) {
            highestValue = Math.max(highestValue, material1.getRepairValueOfItem(material));
        }
        return highestValue;
    }

    private List<Material> getRepairMaterialsPrivate(ItemStack itemStack) {
        Material material;
        Optional<Double> optional;
        double lowest = Double.MAX_VALUE;
        ArrayList<Material> materials = new ArrayList<Material>();
        for (ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            optional = this.getValue(itemStack);
            if (!optional.isPresent() || (material = MaterialProperty.getMaterial(moduleInstance)) == null || !(lowest > optional.get())) continue;
            lowest = optional.get();
        }
        for (ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            optional = this.getValue(itemStack);
            if (!optional.isPresent() || (material = MaterialProperty.getMaterial(moduleInstance)) == null || !(Math.abs(lowest - optional.get()) < 0.001)) continue;
            materials.add(material);
        }
        return materials;
    }

    static {
        KEY = Miapi.id("repair_priority");
    }
}

