/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.attributes;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.armor.EquipmentSlotProperty;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class AttributeProperty
extends CodecProperty<Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>>>
implements ComponentApplyProperty {
    public static final ResourceLocation KEY = Miapi.id("attributes");
    public static AttributeProperty property;
    public static final Map<String, Supplier<Attribute>> replaceMap;
    public static final Map<Attribute, Float> priorityMap;
    public static Codec<List<AttributeJson>> OLD_CODEC;
    public static Codec<Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>>> NEW_CODEC;
    public static Codec<Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>>> CODEC;

    public AttributeProperty() {
        super(CODEC);
        property = this;
        priorityMap.put((Attribute)Attributes.ARMOR.value(), Float.valueOf(-15.0f));
        priorityMap.put((Attribute)Attributes.ARMOR_TOUGHNESS.value(), Float.valueOf(-14.0f));
        priorityMap.put((Attribute)Attributes.KNOCKBACK_RESISTANCE.value(), Float.valueOf(-13.0f));
        priorityMap.put((Attribute)Attributes.ATTACK_DAMAGE.value(), Float.valueOf(-12.0f));
        priorityMap.put((Attribute)AttributeRegistry.MAGIC_DAMAGE.value(), Float.valueOf(-11.5f));
        priorityMap.put((Attribute)Attributes.ATTACK_SPEED.value(), Float.valueOf(-11.0f));
        priorityMap.put((Attribute)AttributeRegistry.CRITICAL_DAMAGE.value(), Float.valueOf(-10.9f));
        priorityMap.put((Attribute)AttributeRegistry.CRITICAL_CHANCE.value(), Float.valueOf(-10.8f));
        priorityMap.put((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.value(), Float.valueOf(-10.0f));
        priorityMap.put((Attribute)AttributeRegistry.PROJECTILE_SPEED.value(), Float.valueOf(-9.0f));
        priorityMap.put((Attribute)AttributeRegistry.PROJECTILE_ACCURACY.value(), Float.valueOf(-9.0f));
        priorityMap.put((Attribute)AttributeRegistry.PROJECTILE_PIERCING.value(), Float.valueOf(-9.0f));
        priorityMap.put((Attribute)AttributeRegistry.MINING_SPEED_AXE.value(), Float.valueOf(-8.0f));
        priorityMap.put((Attribute)AttributeRegistry.MINING_SPEED_PICKAXE.value(), Float.valueOf(-8.0f));
        priorityMap.put((Attribute)AttributeRegistry.MINING_SPEED_HOE.value(), Float.valueOf(-8.0f));
        priorityMap.put((Attribute)AttributeRegistry.MINING_SPEED_SHOVEL.value(), Float.valueOf(-8.0f));
        priorityMap.put((Attribute)Attributes.BLOCK_INTERACTION_RANGE.value(), Float.valueOf(-7.0f));
        priorityMap.put((Attribute)Attributes.ENTITY_INTERACTION_RANGE.value(), Float.valueOf(-7.0f));
        priorityMap.put((Attribute)AttributeRegistry.BACK_STAB.value(), Float.valueOf(-6.0f));
        priorityMap.put((Attribute)AttributeRegistry.SHIELD_BREAK.value(), Float.valueOf(-6.0f));
        priorityMap.put((Attribute)AttributeRegistry.ARMOR_CRUSHING.value(), Float.valueOf(-6.0f));
        replaceMap.put("miapi:generic.reach", () -> ((Holder)Attributes.BLOCK_INTERACTION_RANGE).value());
        replaceMap.put("miapi:generic.attack_range", () -> ((Holder)Attributes.ENTITY_INTERACTION_RANGE).value());
        replaceMap.put("forge:block_reach", () -> ((Holder)Attributes.BLOCK_INTERACTION_RANGE).value());
        replaceMap.put("forge:entity_reach", () -> ((Holder)Attributes.ENTITY_INTERACTION_RANGE).value());
        replaceMap.put("reach-entity-attributes:reach", () -> ((Holder)Attributes.BLOCK_INTERACTION_RANGE).value());
        replaceMap.put("reach-entity-attributes:attack_range", () -> ((Holder)Attributes.ENTITY_INTERACTION_RANGE).value());
    }

    @Override
    public void updateComponent(ItemStack itemStack, RegistryAccess registryAccess) {
        ItemAttributeModifiers attributes = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        ArrayList<ItemAttributeModifiers.Entry> filteredList = new ArrayList<ItemAttributeModifiers.Entry>(attributes.modifiers().stream().filter(entry -> !entry.modifier().id().getNamespace().equals("miapi") && !entry.modifier().id().equals((Object)Item.BASE_ATTACK_DAMAGE_ID) && !entry.modifier().id().equals((Object)Item.BASE_ATTACK_SPEED_ID)).toList());
        this.getData(itemStack).ifPresent(idMap -> {
            AttributeUtil.AttributeContext context = new AttributeUtil.AttributeContext();
            context.map = idMap;
            ((AttributeUtil.ItemAttributeAdjustEvent)AttributeUtil.ITEM_ATTRIBUTE_ADJUST.invoker()).adjust(context, itemStack);
            idMap = context.map;
            idMap.forEach((id, operationMap) -> {
                Attribute attribute = this.findAttribute((ResourceLocation)id);
                if (attribute != null) {
                    operationMap.forEach((attributeOperation, equipmentSlotMap) -> equipmentSlotMap.forEach((slot, operation) -> {
                        EquipmentSlotGroup slotGroup = EquipmentSlotProperty.getSlot(itemStack);
                        if (slot.left().isPresent()) {
                            slotGroup = (EquipmentSlotGroup)slot.left().get();
                        }
                        if (slotGroup == null) {
                            slotGroup = EquipmentSlotGroup.ANY;
                        }
                        ResourceLocation slotId = AttributeUtil.getIDForSlot(slotGroup, attribute, attributeOperation);
                        double value = operation.getValue();
                        filteredList.add(new ItemAttributeModifiers.Entry(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)attribute), new AttributeModifier(slotId, value, attributeOperation), slotGroup));
                    }));
                }
            });
        });
        AttributeUtil.ItemVanillaAttributeContext context = new AttributeUtil.ItemVanillaAttributeContext();
        context.list = filteredList;
        ((AttributeUtil.ItemVanillaAttributeAdjustEvent)AttributeUtil.VANILLA_ITEM_ATTRIBUTE_ADJUST.invoker()).adjust(context, itemStack);
        itemStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers(context.list, true));
    }

    public Attribute findAttribute(ResourceLocation id) {
        Supplier<Attribute> replacement = replaceMap.get(id.toString());
        if (replacement != null) {
            return replacement.get();
        }
        return (Attribute)BuiltInRegistries.ATTRIBUTE.get(id);
    }

    @Override
    public Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> merge(Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> left, Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (id, leftMap, rightMap) -> MergeAble.mergeMap(leftMap, rightMap, mergeType, (operation, leftOperationMap, rightOperationMap) -> MergeAble.mergeMap(leftOperationMap, rightOperationMap, mergeType, (slot, leftJson, rightJson) -> DoubleOperationResolvable.merge(leftJson, rightJson, mergeType))));
    }

    @Override
    public Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> initialize(Map<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> map, ModuleInstance moduleInstance) {
        LinkedHashMap<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>> init = new LinkedHashMap<ResourceLocation, Map<AttributeModifier.Operation, Map<Either<EquipmentSlotGroup, Boolean>, DoubleOperationResolvable>>>();
        map.forEach((id, attributeOpMap) -> attributeOpMap.forEach((op, groupMap) -> groupMap.forEach((slot, resolveAble) -> init.computeIfAbsent((ResourceLocation)id, s -> new LinkedHashMap()).computeIfAbsent(op, a -> new LinkedHashMap()).computeIfAbsent(slot, b -> resolveAble.initialize(moduleInstance)))));
        AttributeUtil.AttributeContext context = new AttributeUtil.AttributeContext();
        context.map = init;
        ((AttributeUtil.AttributeAdjustEvent)AttributeUtil.MODULE_ATTRIBUTE_ADJUST.invoker()).adjust(context, moduleInstance);
        return context.map;
    }

    static {
        replaceMap = new HashMap<String, Supplier<Attribute>>();
        priorityMap = new HashMap<Attribute, Float>();
        OLD_CODEC = Codec.list((Codec)AutoCodec.of(AttributeJson.class).codec());
        NEW_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC.xmap(id -> {
            if (replaceMap.containsKey(id.toString())) {
                return BuiltInRegistries.ATTRIBUTE.getKey((Object)replaceMap.get(id.toString()).get());
            }
            return id;
        }, id -> id), (Codec)Codec.unboundedMap((Codec)AttributeModifier.Operation.CODEC, (Codec)Codec.unboundedMap((Codec)Codec.either((Codec)EquipmentSlotGroup.CODEC, (Codec)Codec.BOOL), DoubleOperationResolvable.CODEC)));
        CODEC = Codec.withAlternative(NEW_CODEC, (Codec)OLD_CODEC.xmap(list -> {
            LinkedHashMap map = new LinkedHashMap();
            list.forEach(attributeJson -> {
                ResourceLocation id = replaceMap.containsKey(attributeJson.attribute) ? BuiltInRegistries.ATTRIBUTE.getKey((Object)replaceMap.get(attributeJson.attribute).get()) : ResourceLocation.parse((String)attributeJson.attribute);
                AttributeModifier.Operation operation = DoubleOperationResolvable.Operation.getOperation(attributeJson.operation);
                AttributeModifier.Operation targetOperation = DoubleOperationResolvable.Operation.getOperation(attributeJson.targetOperation == null ? "+" : attributeJson.targetOperation);
                EquipmentSlotGroup equipmentSlotGroup = attributeJson.slot;
                DoubleOperationResolvable.Operation doubleOperation = new DoubleOperationResolvable.Operation(attributeJson.value);
                if (targetOperation.equals((Object)AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                    operation = operation.equals((Object)AttributeModifier.Operation.ADD_MULTIPLIED_BASE) ? AttributeModifier.Operation.ADD_VALUE : AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
                }
                if (targetOperation.equals((Object)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                    operation = AttributeModifier.Operation.ADD_VALUE;
                }
                doubleOperation.attributeOperation = operation;
                map.computeIfAbsent(id, i -> new LinkedHashMap()).computeIfAbsent(targetOperation, t -> new LinkedHashMap()).compute(Either.left((Object)equipmentSlotGroup), (e, resolvable1) -> {
                    if (resolvable1 == null) {
                        return new DoubleOperationResolvable(List.of(doubleOperation));
                    }
                    ArrayList<DoubleOperationResolvable.Operation> operations = new ArrayList<DoubleOperationResolvable.Operation>(resolvable1.operations);
                    operations.add(doubleOperation);
                    return new DoubleOperationResolvable(operations);
                });
            });
            return map;
        }, map -> List.of()));
    }

    public static class AttributeJson {
        public static Codec<EquipmentSlotGroup> EQUIPMENTSLOT_CODEC = EquipmentSlotGroup.CODEC;
        public String attribute;
        public String value;
        public String operation;
        @CodecBehavior.Override(value="EQUIPMENTSLOT_CODEC")
        public EquipmentSlotGroup slot;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="target_operation")
        public String targetOperation;
    }
}

