/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.mixin.NamedAccessor;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class AllowedEnchantments
extends CodecProperty<AllowedEnchantsData>
implements ComponentApplyProperty {
    public static final ResourceLocation KEY = Miapi.id("enchantments");
    public static AllowedEnchantments property;
    public static Map<ResourceLocation, List<ResourceLocation>> enchantmentExtentionsMap;

    public AllowedEnchantments() {
        super(AllowedEnchantsData.CODEC);
        property = this;
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            enchantmentExtentionsMap = new HashMap(Map.of(ResourceLocation.parse((String)"c:enchantable/pickaxe"), new ArrayList(), ResourceLocation.parse((String)"c:enchantable/axe"), new ArrayList(), ResourceLocation.parse((String)"c:enchantable/shovel"), new ArrayList(), ResourceLocation.parse((String)"c:enchantable/hoe"), new ArrayList()));
            if (registryAccess != null) {
                this.detectEnchantments(registryAccess);
            }
        });
    }

    public void detectEnchantments(RegistryAccess access) {
        List<Item> pickaxes = List.of(Items.WOODEN_PICKAXE, Items.STONE_PICKAXE, Items.GOLDEN_PICKAXE, Items.DIAMOND_PICKAXE, Items.NETHERITE_PICKAXE);
        List<Item> axe = List.of(Items.WOODEN_AXE, Items.STONE_AXE, Items.GOLDEN_AXE, Items.DIAMOND_AXE, Items.NETHERITE_AXE);
        List<Item> shovel = List.of(Items.WOODEN_SHOVEL, Items.STONE_SHOVEL, Items.GOLDEN_SHOVEL, Items.DIAMOND_SHOVEL, Items.NETHERITE_SHOVEL);
        List<Item> hoe = List.of(Items.WOODEN_HOE, Items.STONE_HOE, Items.GOLDEN_HOE, Items.DIAMOND_HOE, Items.NETHERITE_HOE);
        ArrayList<Item> allTools = new ArrayList<Item>(pickaxes);
        allTools.addAll(axe);
        allTools.addAll(shovel);
        allTools.addAll(hoe);
        ((Registry)access.registry(Registries.ENCHANTMENT).get()).forEach(enchantment -> {
            if (!this.allSupportEnchantment((List<Item>)allTools, (Enchantment)enchantment)) {
                ResourceLocation enchantmentID = ((Registry)access.registry(Registries.ENCHANTMENT).get()).getKey(enchantment);
                if (this.allSupportEnchantment(pickaxes, (Enchantment)enchantment)) {
                    enchantmentExtentionsMap.get(ResourceLocation.parse((String)"c:enchantable/pickaxe")).add(enchantmentID);
                }
                if (this.allSupportEnchantment(axe, (Enchantment)enchantment)) {
                    enchantmentExtentionsMap.get(ResourceLocation.parse((String)"c:enchantable/axe")).add(enchantmentID);
                }
                if (this.allSupportEnchantment(shovel, (Enchantment)enchantment)) {
                    enchantmentExtentionsMap.get(ResourceLocation.parse((String)"c:enchantable/shovel")).add(enchantmentID);
                }
                if (this.allSupportEnchantment(hoe, (Enchantment)enchantment)) {
                    enchantmentExtentionsMap.get(ResourceLocation.parse((String)"c:enchantable/hoe")).add(enchantmentID);
                }
            }
        });
    }

    public boolean allSupportEnchantment(List<Item> items, Enchantment enchantment) {
        for (Item item : items) {
            if (enchantment.isSupportedItem(item.getDefaultInstance())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllowed(ItemStack itemStack, Holder<Enchantment> enchantment, boolean oldValue) {
        Optional<AllowedEnchantsData> optional = property.getData(itemStack);
        return optional.map(allowedEnchantsData -> allowedEnchantsData.isAllowed(enchantment).orElse(oldValue)).orElse(oldValue);
    }

    @Override
    public AllowedEnchantsData merge(AllowedEnchantsData left, AllowedEnchantsData right, MergeType mergeType) {
        return new AllowedEnchantsData(MergeAble.mergeList(left.allowed(), right.allowed(), mergeType), MergeAble.mergeList(left.forbidden(), right.forbidden(), mergeType));
    }

    @Override
    public AllowedEnchantsData initialize(AllowedEnchantsData property, ModuleInstance context) {
        return new AllowedEnchantsData(this.initialize(property.allowed()), this.initialize(property.forbidden()));
    }

    public List<ResourceLocation> initialize(List<ResourceLocation> ids) {
        ArrayList<ResourceLocation> expanded = new ArrayList<ResourceLocation>(ids);
        for (ResourceLocation id : ids) {
            if (!enchantmentExtentionsMap.containsKey(id)) continue;
            expanded.addAll((Collection<ResourceLocation>)enchantmentExtentionsMap.get(id));
        }
        return expanded.stream().distinct().toList();
    }

    @Override
    public void updateComponent(ItemStack itemStack, @Nullable RegistryAccess registryAccess) {
        if (itemStack.has(DataComponents.ENCHANTMENTS)) {
            ItemEnchantments enchantments = itemStack.getEnchantments();
            itemStack.update(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY, old -> {
                ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(old);
                this.getData(itemStack).ifPresent(data -> enchantments.keySet().forEach(e -> {
                    Optional<Boolean> optional = data.isAllowed((Holder<Enchantment>)e);
                    if (optional.isEmpty() || !optional.get().booleanValue()) {
                        mutable.removeIf(enchant -> ((Enchantment)enchant.value()).equals(e.value()));
                    }
                }));
                return mutable.toImmutable();
            });
        }
    }

    static {
        enchantmentExtentionsMap = new HashMap<ResourceLocation, List<ResourceLocation>>();
    }

    public record AllowedEnchantsData(List<ResourceLocation> allowed, List<ResourceLocation> forbidden) {
        public static Codec<Either<Holder<Enchantment>, ResourceLocation>> codec = Codec.either((Codec)Enchantment.CODEC, (Codec)ResourceLocation.CODEC);
        public static Codec<AllowedEnchantsData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("allowed", List.of()).forGetter(AllowedEnchantsData::allowed), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("forbidden", List.of()).forGetter(AllowedEnchantsData::allowed)).apply((Applicative)instance, AllowedEnchantsData::new));

        Optional<Boolean> isAllowed(Holder<Enchantment> enchantment) {
            if (this.contains(enchantment, this.forbidden())) {
                return Optional.of(false);
            }
            if (this.contains(enchantment, this.allowed)) {
                return Optional.of(true);
            }
            return Optional.empty();
        }

        private boolean contains(Holder<Enchantment> enchantment, List<ResourceLocation> ids) {
            for (ResourceLocation id : ids) {
                HolderSet.Named set;
                ResourceLocation tagID;
                if (enchantment.is(id)) {
                    return true;
                }
                HolderSet holderSet = ((Enchantment)enchantment.value()).definition().supportedItems();
                if (!(holderSet instanceof HolderSet.Named) || !(tagID = ((NamedAccessor)(set = (HolderSet.Named)holderSet)).getKey().location()).equals((Object)id)) continue;
                return true;
            }
            return false;
        }
    }
}

