/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class CraftingEnchantProperty
extends CodecProperty<Map<ResourceLocation, DoubleOperationResolvable>>
implements ComponentApplyProperty {
    public static final ResourceLocation KEY = Miapi.id("crafting_enchants");
    public static CraftingEnchantProperty property;
    public static Codec<Map<ResourceLocation, DoubleOperationResolvable>> CODEC;

    public CraftingEnchantProperty() {
        super(CODEC);
        property = this;
    }

    @Override
    public void updateComponent(ItemStack itemStack, RegistryAccess registryAccess) {
        this.getData(itemStack).ifPresent(stringDoubleOperationResolvableMap -> EnchantmentHelper.updateEnchantments((ItemStack)itemStack, mutable -> stringDoubleOperationResolvableMap.forEach((enchantmentID, value) -> {
            try {
                CraftingEnchantProperty.tryAndLookUp(enchantmentID, ItemModule.getModules(itemStack)).ifPresent(enchantment -> {
                    int prevLevel = mutable.getLevel(enchantment);
                    value.setFunctionTransformer(s -> ((String)s.getFirst()).replace("[old_level]", String.valueOf(prevLevel)));
                    int nextLevel = (int)value.evaluate(0.0, prevLevel);
                    if (MiapiConfig.getServerConfig().other.verboseLogging) {
                        Miapi.LOGGER.info("updated level to " + String.valueOf(((Enchantment)enchantment.value()).description()) + " " + nextLevel);
                    }
                    mutable.set(enchantment, nextLevel);
                });
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.info("failed to apply enchantments!", (Throwable)e);
            }
        })));
    }

    public static Map<Holder<Enchantment>, DoubleOperationResolvable> tryConvert(Map<ResourceLocation, DoubleOperationResolvable> original, ItemStack itemStack) {
        HashMap<Holder<Enchantment>, DoubleOperationResolvable> mapped = new HashMap<Holder<Enchantment>, DoubleOperationResolvable>();
        original.forEach((id, ench) -> CraftingEnchantProperty.tryAndLookUp(id, itemStack).ifPresent(holder -> mapped.put((Holder<Enchantment>)holder, (DoubleOperationResolvable)ench)));
        return mapped;
    }

    public static Optional<Holder<Enchantment>> tryAndLookUp(ResourceLocation id, ItemStack reference) {
        return CraftingEnchantProperty.tryAndLookUp(id, ItemModule.getModules(reference));
    }

    public static Optional<Holder<Enchantment>> tryAndLookUp(ResourceLocation id, ModuleInstance reference) {
        if (reference.registryAccess == null || reference.lookup == null) {
            return Optional.empty();
        }
        Registry registry = (Registry)reference.registryAccess.registry(Registries.ENCHANTMENT).get();
        ResourceKey enchantmentResourceKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id);
        Optional lookup = reference.lookup.lookup(Registries.ENCHANTMENT);
        if (lookup.isEmpty()) {
            Miapi.LOGGER.info("Enchantment Registry could not be found!");
            return Optional.empty();
        }
        try {
            Optional optional = ((RegistryOps.RegistryInfo)lookup.get()).getter().get(enchantmentResourceKey);
            if (optional.isEmpty()) {
                Miapi.LOGGER.info("could not find enchantment " + String.valueOf(id));
                return Optional.empty();
            }
            return Optional.of((Holder)((RegistryOps.RegistryInfo)lookup.get()).getter().get(enchantmentResourceKey).get());
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.warn("could not properly lookup enchantments!", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Map<ResourceLocation, DoubleOperationResolvable> initialize(Map<ResourceLocation, DoubleOperationResolvable> property, ModuleInstance context) {
        LinkedHashMap<ResourceLocation, DoubleOperationResolvable> init = new LinkedHashMap<ResourceLocation, DoubleOperationResolvable>();
        property.forEach((key, value) -> init.put((ResourceLocation)key, value.initialize(context)));
        return init;
    }

    @Override
    public Map<ResourceLocation, DoubleOperationResolvable> merge(Map<ResourceLocation, DoubleOperationResolvable> left, Map<ResourceLocation, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    static {
        CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, DoubleOperationResolvable.CODEC);
    }
}

