/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.enchanment.FakeEnchantmentManager;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.EitherModuleProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class FakeEitherEnchantmentProperty
extends EitherModuleProperty<Map<ResourceLocation, DoubleOperationResolvable>, Map<Holder.Reference<Enchantment>, DoubleOperationResolvable>> {
    public static final ResourceLocation KEY = Miapi.id("fake_enchants");
    public static Codec<Map<ResourceLocation, DoubleOperationResolvable>> CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, DoubleOperationResolvable.CODEC);

    public FakeEitherEnchantmentProperty() {
        super(CODEC);
        FakeEnchantmentManager.transformerList.add((enchantmentHolder, itemStack, oldLevel) -> {
            for (Map.Entry<Holder.Reference<Enchantment>, DoubleOperationResolvable> location : this.getEnchants(itemStack).entrySet()) {
                if (!enchantmentHolder.is((Holder)location.getKey())) continue;
                DoubleOperationResolvable resolvable = location.getValue();
                resolvable.setFunctionTransformer(s -> ((String)s.getFirst()).replace("[old_level]", String.valueOf(oldLevel)));
                return (int)resolvable.evaluate(0.0, oldLevel);
            }
            return oldLevel;
        });
        FakeEnchantmentManager.ADD_ENCHANTMENT.register(enchantmentMap -> {
            for (Map.Entry<Holder.Reference<Enchantment>, DoubleOperationResolvable> location : this.getEnchants(enchantmentMap.referenceStack).entrySet()) {
                if (enchantmentMap.enchantments.contains(location.getKey())) continue;
                enchantmentMap.enchantments.add((Holder<Enchantment>)((Holder)location.getKey()));
            }
            return EventResult.pass();
        });
        if (Environment.isClient()) {
            this.setupClient();
        }
    }

    @Override
    protected Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> initializeDecode(Map<ResourceLocation, DoubleOperationResolvable> property, ModuleInstance context) {
        HashMap<Holder.Reference<Enchantment>, DoubleOperationResolvable> initialized = new HashMap<Holder.Reference<Enchantment>, DoubleOperationResolvable>();
        property.forEach((id, resolvable) -> {
            if (context.lookup != null) {
                context.lookup.lookup(Registries.ENCHANTMENT).ifPresentOrElse(enchantmentRegistryInfo -> enchantmentRegistryInfo.getter().get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id)).ifPresentOrElse(holder -> {
                    initialized.put((Holder.Reference<Enchantment>)holder, resolvable.initialize(context));
                    Miapi.LOGGER.info("full ID " + String.valueOf(holder.key().location()));
                }, () -> Miapi.LOGGER.warn("Could not find enchanment " + String.valueOf(id) + " skiping")), () -> Miapi.LOGGER.warn("Enchantment Registries not Found - could not decode enchantments"));
            } else {
                Miapi.LOGGER.warn("could not decode enchantments - missing lookup!");
            }
        });
        return initialized;
    }

    @Override
    protected Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> mergeInterpreted(Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> left, Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    @Override
    protected Map<ResourceLocation, DoubleOperationResolvable> mergeRaw(Map<ResourceLocation, DoubleOperationResolvable> left, Map<ResourceLocation, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    @Override
    protected Map<ResourceLocation, DoubleOperationResolvable> deInitialize(Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> property) {
        HashMap<ResourceLocation, DoubleOperationResolvable> map = new HashMap<ResourceLocation, DoubleOperationResolvable>();
        property.forEach((id, resolvable) -> map.put(id.key().location(), (DoubleOperationResolvable)resolvable));
        return map;
    }

    public Map<Holder.Reference<Enchantment>, DoubleOperationResolvable> getEnchants(ItemStack itemStack) {
        if (this.getData(itemStack).isPresent() && ((Either)this.getData(itemStack).get()).right().isPresent()) {
            return (Map)((Either)this.getData(itemStack).get()).right().get();
        }
        return Map.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient() {
        StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                ArrayList displays = new ArrayList();
                HashSet<Holder.Reference<Enchantment>> enchantments = new HashSet<Holder.Reference<Enchantment>>();
                enchantments.addAll(FakeEitherEnchantmentProperty.this.getEnchants(original).keySet());
                enchantments.addAll(FakeEitherEnchantmentProperty.this.getEnchants(compareTo).keySet());
                enchantments.forEach(enchantment -> {
                    JsonStatDisplay display = new JsonStatDisplay(stack -> ((Enchantment)enchantment.value()).description(), stack -> ((Enchantment)enchantment.value()).description(), new SingleStatDisplayDouble.StatReaderHelper(){
                        final /* synthetic */ Holder val$enchantment;
                        {
                            this.val$enchantment = holder;
                        }

                        @Override
                        public double getValue(ItemStack itemStack) {
                            return EnchantmentHelper.getItemEnchantmentLevel((Holder)this.val$enchantment, (ItemStack)itemStack);
                        }

                        @Override
                        public boolean hasValue(ItemStack itemStack) {
                            return true;
                        }
                    }, 0.0, ((Enchantment)enchantment.value()).getMaxLevel());
                    if (enchantment.is(EnchantmentTags.CURSE)) {
                        display.inverse = true;
                    }
                    displays.add(display);
                });
                return displays;
            }
        });
    }
}

