/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.redpxnda.nucleus.event.PrioritizedEvent;
import dev.architectury.event.EventResult;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import smartin.miapi.item.modular.VisualModularItem;

public class FakeEnchantmentManager {
    public static Map<ItemEnchantments, ItemStack> lookupMap = new WeakHashMap<ItemEnchantments, ItemStack>();
    public static List<LevelTransformer> transformerList = new ArrayList<LevelTransformer>();
    public static final PrioritizedEvent<AddEnchantmentEvent> ADD_ENCHANTMENT = PrioritizedEvent.createEventResult((Object[])new AddEnchantmentEvent[0]);

    public static Set<Object2IntMap.Entry<Holder<Enchantment>>> adjustEnchantments(Set<Object2IntMap.Entry<Holder<Enchantment>>> immutableMap, ItemStack itemStack) {
        EnchantmentMap enchantmentMap = new EnchantmentMap(immutableMap, itemStack);
        ((AddEnchantmentEvent)ADD_ENCHANTMENT.invoker()).adjust(enchantmentMap);
        HashMap<Holder, Integer> map = new HashMap<Holder, Integer>();
        enchantmentMap.immutableMap.forEach(holderEntry -> map.put((Holder)holderEntry.getKey(), holderEntry.getIntValue()));
        enchantmentMap.enchantments.forEach(enchantmentHolder -> {
            if (!map.containsKey(enchantmentHolder)) {
                map.put((Holder)enchantmentHolder, 0);
            }
        });
        Object2IntOpenHashMap resultMap = new Object2IntOpenHashMap();
        map.forEach((enchantmentHolder, integer) -> {
            int level = integer;
            for (LevelTransformer levelTransformer : transformerList) {
                level = levelTransformer.adjust((Holder<Enchantment>)enchantmentHolder, itemStack, level);
            }
            resultMap.put(enchantmentHolder, level);
        });
        return resultMap.object2IntEntrySet();
    }

    public static int adjustLevel(Holder<Enchantment> enchantmentHolder, int prevLevel, ItemStack itemStack) {
        for (LevelTransformer levelTransformer : transformerList) {
            prevLevel = levelTransformer.adjust(enchantmentHolder, itemStack, prevLevel);
        }
        return prevLevel;
    }

    public static void initOnItemStack(ItemStack stack) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.getComponents().get(DataComponents.ENCHANTMENTS);
        if (enchantments != null && stack.getItem() instanceof VisualModularItem) {
            lookupMap.put(enchantments, stack);
        }
    }

    public static class EnchantmentMap {
        public Set<Object2IntMap.Entry<Holder<Enchantment>>> immutableMap;
        public List<Holder<Enchantment>> enchantments = new ArrayList<Holder<Enchantment>>();
        public ItemStack referenceStack;

        public EnchantmentMap(Set<Object2IntMap.Entry<Holder<Enchantment>>> immutableMap, ItemStack itemStack) {
            this.immutableMap = immutableMap;
            this.referenceStack = itemStack;
            immutableMap.forEach(holderEntry -> this.enchantments.add((Holder<Enchantment>)((Holder)holderEntry.getKey())));
        }
    }

    public static interface AddEnchantmentEvent {
        public EventResult adjust(EnchantmentMap var1);
    }

    public static interface LevelTransformer {
        public int adjust(Holder<Enchantment> var1, ItemStack var2, int var3);
    }
}

