/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.inventory;

import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class InventoryProperty
extends DoubleProperty {
    public static InventoryProperty property;

    public InventoryProperty(ResourceLocation cacheKey) {
        super(cacheKey);
        property = this;
    }

    public List<ItemStack> getSlots(ModuleInstance moduleInstance, ItemStack backPackItem) {
        Tag tag;
        int slotCount = this.getValue(moduleInstance).get().intValue();
        NonNullList slots = NonNullList.withSize((int)slotCount, (Object)ItemStack.EMPTY);
        JsonElement data = moduleInstance.moduleData.get(this.id);
        if (data != null && data.isJsonArray() && (tag = (Tag)JsonOps.INSTANCE.convertTo(Miapi.BOOL_CORRECTED_OPS, data)) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            ContainerHelper.loadAllItems((CompoundTag)compoundTag, (NonNullList)slots, (HolderLookup.Provider)moduleInstance.registryAccess);
        }
        return slots;
    }

    public void save(ModuleInstance moduleInstance, List<ItemStack> items) {
        int slotCount = this.getValue(moduleInstance).get().intValue();
        NonNullList slots = NonNullList.withSize((int)slotCount, (Object)ItemStack.EMPTY);
        for (int i = 0; i < Math.min(slotCount, items.size()); ++i) {
            slots.set(i, (Object)items.get(i));
        }
        ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), (NonNullList)slots, (HolderLookup.Provider)moduleInstance.registryAccess);
    }
}

