/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.inventory;

import com.redpxnda.nucleus.util.Color;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.joml.Vector4i;
import smartin.miapi.Miapi;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.inventory.InventoryProperty;

public class ItemInventoryManager {
    public static final Map<ResourceLocation, Function<Player, SlotInfo>> PLAYER_TO_SLOT = new HashMap<ResourceLocation, Function<Player, SlotInfo>>();
    public static final Map<ResourceLocation, Function<ItemStack, InventoryType>> CONTAINERS_FOR_ITEMSTACK = new HashMap<ResourceLocation, Function<ItemStack, InventoryType>>();
    public static KeyMapping open = MiapiClient.KEY_BINDINGS.register(Miapi.id("open_backpack"), new KeyMapping("miapi.binding.open_backpack", 0, "miapi.binding"));

    public static void setup() {
        ItemInventoryManager.registerArmorSlots();
        CONTAINERS_FOR_ITEMSTACK.put(Miapi.id("backpack"), stack -> {
            Optional<Double> size = InventoryProperty.property.getValue((ItemStack)stack);
            if (size.isPresent()) {
                return new BackpackInventory((ItemStack)stack, size.get());
            }
            return null;
        });
        MiapiEvents.PLAYER_TICK_END.register((Object)new MiapiEvents.PlayerTickEvent(){

            @Override
            public EventResult tick(Player player) {
                if (!open.consumeClick() || player.level().isClientSide) {
                    // empty if block
                }
                return EventResult.pass();
            }
        });
    }

    private static void registerArmorSlots() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            Color color = new Color((Vector4i)Color.AQUA);
            PLAYER_TO_SLOT.put(Miapi.id("armor_" + slot.getName()), player -> new ArmorSlotInfo((Player)player, slot, color));
        }
    }

    public static Map<SlotInfo, List<InventoryType>> getInventoryForPlayer(Player player) {
        HashMap<SlotInfo, List<InventoryType>> map = new HashMap<SlotInfo, List<InventoryType>>();
        PLAYER_TO_SLOT.forEach((id, function) -> {
            SlotInfo info = (SlotInfo)function.apply(player);
            if (!info.getStack().isEmpty()) {
                ArrayList inventoryTypes = new ArrayList();
                CONTAINERS_FOR_ITEMSTACK.forEach((slotId, inventoryTypeFunction) -> {
                    InventoryType type = (InventoryType)inventoryTypeFunction.apply(info.getStack());
                    if (type != null && type.getSize() > 0) {
                        inventoryTypes.add(type);
                    }
                });
                if (!inventoryTypes.isEmpty()) {
                    map.put(info, inventoryTypes);
                }
            }
        });
        return map;
    }

    public static interface SlotInfo {
        public ItemStack getStack();

        public Color getColor();

        public Component getName();

        public void renderIcon(int var1, int var2, int var3, int var4);

        public void setStack(ItemStack var1);
    }

    public static interface InventoryType {
        public ItemContainerContents getContents();

        public boolean canEnter(ItemStack var1);

        public int getSize();

        public void saveToItem();

        public Component getName();
    }

    public static class ArmorSlotInfo
    implements SlotInfo {
        private final Player player;
        private final EquipmentSlot slot;
        private final Color color;

        public ArmorSlotInfo(Player player, EquipmentSlot slot, Color color) {
            this.player = player;
            this.slot = slot;
            this.color = color;
        }

        @Override
        public ItemStack getStack() {
            return this.player.getItemBySlot(this.slot);
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public Component getName() {
            return Component.translatable((String)("miapi.slot.armor." + this.slot.getName()));
        }

        @Override
        public void renderIcon(int x, int y, int width, int height) {
        }

        @Override
        public void setStack(ItemStack stack) {
            this.player.setItemSlot(this.slot, stack);
        }
    }

    public static class BackpackInventory
    implements InventoryType {
        private final ItemStack stack;
        private final int size;

        public BackpackInventory(ItemStack stack, double size) {
            this.stack = stack;
            this.size = (int)size;
        }

        @Override
        public ItemContainerContents getContents() {
            return ItemContainerContents.fromItems(List.of());
        }

        @Override
        public boolean canEnter(ItemStack itemStack) {
            return true;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void saveToItem() {
        }

        @Override
        public Component getName() {
            return Component.translatable((String)"miapi.inventory.backpack");
        }
    }
}

