/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.inventory;

import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import smartin.miapi.modules.properties.inventory.CustomInventoryMenu;
import smartin.miapi.modules.properties.inventory.ItemInventoryManager;

public abstract class ParentHandledScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.parse((String)"textures/gui/container/generic_54.png");
    private static final int SLOT_SIZE = 18;
    private static final int SLOT_SPACING = 4;
    private static final int TITLE_SPACING = 10;

    public ParentHandledScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 222;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof CustomInventoryMenu) {
            CustomInventoryMenu customMenu = (CustomInventoryMenu)abstractContainerMenu;
            Map<ItemInventoryManager.SlotInfo, List<ItemInventoryManager.InventoryType>> inventoryMap = customMenu.getInventoryMap();
            int currentY = this.topPos + 10;
            for (Map.Entry<ItemInventoryManager.SlotInfo, List<ItemInventoryManager.InventoryType>> entry : inventoryMap.entrySet()) {
                ItemInventoryManager.SlotInfo slotInfo = entry.getKey();
                List<ItemInventoryManager.InventoryType> inventoryTypes = entry.getValue();
                context.drawString(this.font, slotInfo.getName().getString(), this.leftPos + 8, currentY, 0x404040, false);
                currentY += 10;
                for (ItemInventoryManager.InventoryType inventoryType : inventoryTypes) {
                    int color = slotInfo.getColor().argb();
                    int slots = inventoryType.getSize();
                    int rows = (int)Math.ceil((double)slots / 9.0);
                    for (int row = 0; row < rows; ++row) {
                        for (int col = 0; col < Math.min(9, slots - row * 9); ++col) {
                            int x = this.leftPos + 8 + col * 22;
                            int y = currentY + row * 22;
                            context.fill(x, y, x + 18, y + 18, color);
                            context.blit(BACKGROUND_TEXTURE, x, y, 0, 0, 18, 18);
                        }
                    }
                    currentY += rows * 22 + 10;
                }
            }
        }
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, 8, 6, 0x404040, false);
        context.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }
}

