/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class MiningLevelProperty
extends CodecProperty<Map<String, MiningRule>>
implements ComponentApplyProperty {
    public static MiningLevelProperty property;
    public static final ResourceLocation KEY;
    public static Map<String, TagKey<Block>> miningCapabilities;
    public static Codec<Map<String, MiningRule>> CODEC;
    public static String CACHEKEY;

    public MiningLevelProperty() {
        super(CODEC);
        property = this;
        ModularItemCache.setSupplier(CACHEKEY, this::asComponent);
    }

    @Override
    public Map<String, MiningRule> merge(Map<String, MiningRule> left, Map<String, MiningRule> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (k, l, r) -> MiningRule.merge(l, r, mergeType));
    }

    @Override
    public Map<String, MiningRule> initialize(Map<String, MiningRule> data, ModuleInstance context) {
        HashMap<String, MiningRule> initialized = new HashMap<String, MiningRule>();
        data.forEach((key, entry) -> initialized.put((String)key, entry.initialize(context)));
        return initialized;
    }

    Tool asComponent(ItemStack itemStack) {
        ArrayList rules = new ArrayList();
        Map rawData = this.getData(itemStack).orElse(new HashMap());
        rawData.values().forEach(miningRule -> rules.addAll(miningRule.asRules()));
        return new Tool(rules, 1.0f, 1);
    }

    Tool asComponentCached(ItemStack itemStack) {
        return ModularItemCache.get(itemStack, CACHEKEY, new Tool(new ArrayList(), 1.0f, 1));
    }

    @Override
    public void updateComponent(ItemStack itemStack, RegistryAccess registryAccess) {
        itemStack.set(DataComponents.TOOL, (Object)new Tool(new ArrayList(), 1.0f, 1));
    }

    public static float getDestroySpeed(ItemStack stack, BlockState state) {
        return Math.max(property.asComponentCached(stack).getMiningSpeed(state), 1.0f);
    }

    public static boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        Tool tool = property.asComponentCached(stack);
        return tool.isCorrectForDrops(state);
    }

    public static boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Tool ourComponent = property.asComponentCached(stack);
        int toolDamage = ourComponent.damagePerBlock();
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && toolDamage > 0) {
            stack.hurtAndBreak(toolDamage, miningEntity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    private static List<Holder<Block>> toList(List<HolderSet<Block>> blocks) {
        ArrayList<Holder<Block>> canDropBlocks = new ArrayList<Holder<Block>>();
        BuiltInRegistries.BLOCK.forEach(block -> blocks.forEach(set -> {
            Holder holder = BuiltInRegistries.BLOCK.wrapAsHolder(block);
            if (set.contains(holder)) {
                canDropBlocks.add(holder);
            }
        }));
        return canDropBlocks;
    }

    private static List<Holder<Block>> toList(HolderSet<Block> blocks) {
        ArrayList<Holder<Block>> canDropBlocks = new ArrayList<Holder<Block>>();
        BuiltInRegistries.BLOCK.forEach(block -> {
            Holder holder = BuiltInRegistries.BLOCK.wrapAsHolder(block);
            if (blocks.contains(holder)) {
                canDropBlocks.add(holder);
            }
        });
        return canDropBlocks;
    }

    static {
        KEY = Miapi.id("mining_level");
        miningCapabilities = new HashMap<String, TagKey<Block>>();
        CODEC = Codec.unboundedMap((Codec)Codec.STRING, MiningRule.CODEC);
        CACHEKEY = String.valueOf(KEY) + "finished_component";
    }

    public record MiningRule(List<HolderSet<Block>> blocks, List<HolderSet<Block>> blacklist, DoubleOperationResolvable speed, Optional<Boolean> correctForDrops, boolean useMaterial, List<Material> respectMaterialBlacklists) {
        public static final Codec<MiningRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).listOf().optionalFieldOf("allowed", List.of()).forGetter(MiningRule::blocks), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).listOf().optionalFieldOf("forbidden", List.of()).forGetter(MiningRule::blacklist), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("speed", (Object)new DoubleOperationResolvable(1.0)).forGetter(MiningRule::speed), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("correct_for_drops").forGetter(MiningRule::correctForDrops), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("use_material", (Object)false).forGetter(MiningRule::useMaterial)).apply((Applicative)instance, (blockList, blacklist, speed, correct, useMaterial) -> new MiningRule((List<HolderSet<Block>>)blockList, (List<HolderSet<Block>>)blacklist, (DoubleOperationResolvable)speed, (Optional<Boolean>)correct, (boolean)useMaterial, (List<Material>)new ArrayList<Material>())));

        public static MiningRule merge(MiningRule left, MiningRule right, MergeType mergeType) {
            List<HolderSet<Block>> blocks = MergeAble.mergeList(left.blocks(), right.blocks(), mergeType);
            List<HolderSet<Block>> blacklist = MergeAble.mergeList(left.blacklist(), right.blacklist(), mergeType);
            List<Material> mergedMaterials = MergeAble.mergeList(left.respectMaterialBlacklists(), right.respectMaterialBlacklists(), mergeType);
            DoubleOperationResolvable merged = left.speed().merge(right.speed(), mergeType);
            Optional<Boolean> mergedBoolean = Optional.empty();
            if (left.correctForDrops().isPresent()) {
                mergedBoolean = left.correctForDrops();
            }
            if (right.correctForDrops().isPresent()) {
                mergedBoolean = right.correctForDrops();
            }
            return new MiningRule(blocks, blacklist, merged, mergedBoolean, left.useMaterial() || right.useMaterial(), mergedMaterials);
        }

        public MiningRule initialize(ModuleInstance moduleInstance) {
            Material material;
            ArrayList<HolderSet<Block>> blockBlackList = new ArrayList<HolderSet<Block>>(this.blacklist().stream().toList());
            Optional<Boolean> correctForDrops = this.correctForDrops();
            ArrayList<Material> mergedMaterials = new ArrayList<Material>(this.respectMaterialBlacklists());
            if (this.useMaterial() && (material = MaterialProperty.getMaterial(moduleInstance)) != null) {
                mergedMaterials.add(material);
            }
            return new MiningRule(this.blocks().stream().toList(), blockBlackList, this.speed().initialize(moduleInstance), correctForDrops, this.useMaterial(), mergedMaterials);
        }

        public List<Tool.Rule> asRules() {
            float speedEvaluated = (float)this.speed().evaluate(0.0, 1.0);
            if (speedEvaluated < 1.0f) {
                speedEvaluated = 1.0f;
            }
            if (this.useMaterial()) {
                List<Holder<Block>> canDropBlocks = MiningLevelProperty.toList(this.blocks());
                if (!canDropBlocks.isEmpty()) {
                    MiningLevelProperty.toList(this.blacklist()).stream().map(Holder::value).distinct().forEach(canDropBlocks::remove);
                }
                ArrayList<Holder<Block>> blocksWithMiningSpeed = new ArrayList<Holder<Block>>(canDropBlocks);
                ArrayList toRemoveFromMaterial = new ArrayList();
                this.respectMaterialBlacklists().forEach(material -> {
                    if (toRemoveFromMaterial.isEmpty()) {
                        BuiltInRegistries.BLOCK.getTag(material.getIncorrectBlocksForDrops()).ifPresent(named -> named.stream().distinct().forEach(toRemoveFromMaterial::add));
                    } else {
                        ArrayList notShared = new ArrayList(toRemoveFromMaterial);
                        BuiltInRegistries.BLOCK.getTag(material.getIncorrectBlocksForDrops()).ifPresent(named -> MiningLevelProperty.toList((HolderSet<Block>)named).stream().map(Holder::value).distinct().forEach(notShared::remove));
                        notShared.forEach(toRemoveFromMaterial::remove);
                    }
                });
                toRemoveFromMaterial.forEach(canDropBlocks::remove);
                List<Block> rawBlocks = new HashSet<Holder<Block>>(canDropBlocks).stream().distinct().map(Holder::value).toList();
                Tool.Rule mineAndDrop = Tool.Rule.minesAndDrops(rawBlocks, (float)speedEvaluated);
                Tool.Rule overrideSpeed = Tool.Rule.overrideSpeed(blocksWithMiningSpeed.stream().map(Holder::value).toList(), (float)speedEvaluated);
                return List.of(mineAndDrop, overrideSpeed);
            }
            ArrayList canDropBlocks = new ArrayList();
            this.blocks.forEach(set -> set.forEach(canDropBlocks::add));
            ArrayList forbiddenBlocks = new ArrayList();
            this.blacklist.forEach(set -> set.forEach(canDropBlocks::add));
            return List.of(new Tool.Rule((HolderSet)HolderSet.direct(forbiddenBlocks), Optional.of(Float.valueOf(speedEvaluated)), Optional.of(false)), new Tool.Rule((HolderSet)HolderSet.direct(canDropBlocks), Optional.of(Float.valueOf(speedEvaluated)), this.correctForDrops()));
        }
    }
}

