/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.mining.MiningShapeEntry;
import smartin.miapi.modules.properties.mining.condition.AlwaysMiningCondition;
import smartin.miapi.modules.properties.mining.condition.BlockTagCondition;
import smartin.miapi.modules.properties.mining.condition.MiningCondition;
import smartin.miapi.modules.properties.mining.mode.InstantMiningMode;
import smartin.miapi.modules.properties.mining.mode.MiningMode;
import smartin.miapi.modules.properties.mining.mode.StaggeredMiningMode;
import smartin.miapi.modules.properties.mining.modifier.MiningModifier;
import smartin.miapi.modules.properties.mining.modifier.SameBlockModifier;
import smartin.miapi.modules.properties.mining.shape.CubeMiningShape;
import smartin.miapi.modules.properties.mining.shape.MiningShape;
import smartin.miapi.modules.properties.mining.shape.VeinMiningShape;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeType;

public class MiningShapeProperty
extends CodecProperty<List<MiningShapeEntry>> {
    public static final ResourceLocation KEY = Miapi.id("mining_shape");
    public static MiningShapeProperty property;
    public static Map<ResourceLocation, MapCodec<? extends MiningCondition>> miningConditionMap;
    public static Map<ResourceLocation, MapCodec<? extends MiningShape>> miningShapeMap;
    public static Map<ResourceLocation, MapCodec<? extends MiningMode>> miningModeMap;
    public static Map<ResourceLocation, Codec<? extends MiningModifier>> miningModifierMap;
    public static List<BlockPos> blockedPositions;

    @Override
    public List<MiningShapeEntry> merge(List<MiningShapeEntry> left, List<MiningShapeEntry> right, MergeType mergeType) {
        return List.of();
    }

    public MiningShapeProperty() {
        super(Codec.list(MiningShapeEntry.CODEC));
        property = this;
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            if (!(level.isClientSide() || player.isShiftKeyDown() || blockedPositions.contains(pos))) {
                ItemStack miningItem = player.getMainHandItem();
                List miningShapeJsons = this.getData(miningItem).orElse(new ArrayList());
                HitResult hitResult = player.pick(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, false);
                if (hitResult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    if (!blockHitResult.getBlockPos().equals((Object)pos)) {
                        return EventResult.pass();
                    }
                    Direction facing = blockHitResult.getDirection();
                    miningShapeJsons.stream().filter(miningShapeJson -> miningShapeJson.condition().canMine((Player)player, level, miningItem, pos, facing)).forEach(miningShapeJson -> miningShapeJson.execute(pos, level, miningItem, player, facing));
                }
            }
            return EventResult.pass();
        });
        miningModeMap.put(Miapi.id("instant"), InstantMiningMode.CODEC);
        miningModeMap.put(Miapi.id("staggered"), StaggeredMiningMode.CODEC);
        miningModifierMap.put(Miapi.id("require_same"), SameBlockModifier.CODEC);
        miningConditionMap.put(Miapi.id("always"), AlwaysMiningCondition.CODEC);
        miningConditionMap.put(Miapi.id("block_tag"), BlockTagCondition.CODEC);
        miningShapeMap.put(Miapi.id("cube"), CubeMiningShape.CODEC);
        miningShapeMap.put(Miapi.id("vein"), VeinMiningShape.CODEC);
    }

    static {
        miningConditionMap = new HashMap<ResourceLocation, MapCodec<? extends MiningCondition>>();
        miningShapeMap = new HashMap<ResourceLocation, MapCodec<? extends MiningShape>>();
        miningModeMap = new HashMap<ResourceLocation, MapCodec<? extends MiningMode>>();
        miningModifierMap = new HashMap<ResourceLocation, Codec<? extends MiningModifier>>();
        blockedPositions = Collections.synchronizedList(new ArrayList());
    }
}

