/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.mode;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.mining.mode.MiningMode;

public class InstantMiningMode
implements MiningMode {
    public static MapCodec<InstantMiningMode> CODEC = AutoCodec.of(InstantMiningMode.class);
    public static ResourceLocation ID = Miapi.id("instant");
    @CodecBehavior.Optional
    @AutoCodec.Name(value="durability_break_chance")
    public double durabilityBreakChance = 1.0;

    @Override
    public void execute(List<BlockPos> posList, Level world, ServerPlayer player, BlockPos origin, ItemStack itemStack) {
        ArrayList<BlockPos> reducedList = new ArrayList<BlockPos>(posList);
        reducedList.sort(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)origin)));
        posList.forEach(blockPos -> {
            if (itemStack.getMaxDamage() - itemStack.getDamageValue() > 1 && this.tryBreakBlock(player, (BlockPos)blockPos) && !player.isCreative()) {
                this.removeDurability(this.durabilityBreakChance, itemStack, world, player);
            }
        });
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

