/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.mode;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.properties.mining.MiningShapeProperty;

public interface MiningMode {
    public void execute(List<BlockPos> var1, Level var2, ServerPlayer var3, BlockPos var4, ItemStack var5);

    default public void removeDurability(double durability, ItemStack itemStack, Level world, ServerPlayer player) {
        double additionalChance = durability - Math.floor(durability);
        if (additionalChance > 0.0 && world.random.nextDouble() > additionalChance) {
            durability += 1.0;
        }
        if (Math.floor(durability) > 0.0) {
            itemStack.hurtAndBreak((int)Math.floor(durability), (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }

    public ResourceLocation getID();

    default public boolean tryBreakBlock(ServerPlayer player, BlockPos pos) {
        MiningShapeProperty.blockedPositions.add(pos);
        boolean didBreak = player.gameMode.destroyBlock(pos);
        MiningShapeProperty.blockedPositions.remove(pos);
        return didBreak;
    }
}

