/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.mode;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.mining.mode.MiningMode;

public class StaggeredMiningMode
implements MiningMode {
    public static List<Runnable> nextTickTask = new ArrayList<Runnable>();
    public static MapCodec<StaggeredMiningMode> CODEC = AutoCodec.of(StaggeredMiningMode.class);
    public static ResourceLocation ID = Miapi.id("staggered");
    @CodecBehavior.Optional
    public float speed = 1.0f;
    @CodecBehavior.Optional
    @AutoCodec.Name(value="durability_break_chance")
    public double durabilityBreakChance = 1.0;

    @Override
    public void execute(List<BlockPos> posList, Level world, ServerPlayer player, BlockPos origin, ItemStack itemStack) {
        ArrayList<BlockPos> reducedList = new ArrayList<BlockPos>(posList);
        reducedList.sort(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)origin)));
        nextTickTask.add(() -> {
            int success = 0;
            do {
                BlockPos pos;
                if (!this.tryBreakBlock(player, pos = (BlockPos)reducedList.remove(0))) continue;
                ++success;
                if (player.isCreative()) continue;
                this.removeDurability(this.durabilityBreakChance, itemStack, world, player);
            } while ((float)success < this.speed && !reducedList.isEmpty() && itemStack.getMaxDamage() - itemStack.getDamageValue() > 1);
            if (!reducedList.isEmpty() && itemStack.getMaxDamage() - itemStack.getDamageValue() > 1) {
                this.execute(reducedList, world, player, origin, itemStack);
            }
        });
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    static {
        TickEvent.SERVER_POST.register(server -> {
            ArrayList<Runnable> currentTicks = new ArrayList<Runnable>(nextTickTask);
            nextTickTask.clear();
            currentTicks.forEach(arg_0 -> ((MinecraftServer)server).execute(arg_0));
        });
    }
}

