/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.shape;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.mining.shape.MiningShape;

public class CubeMiningShape
implements MiningShape {
    public static MapCodec<CubeMiningShape> CODEC = AutoCodec.of(CubeMiningShape.class);
    public static ResourceLocation ID = Miapi.id("cube");
    @CodecBehavior.Optional
    public int width = 1;
    @CodecBehavior.Optional
    public int height = 1;
    @CodecBehavior.Optional
    public int depth = 1;

    @Override
    public List<BlockPos> getMiningBlocks(Level world, BlockPos pos, Direction face) {
        ArrayList<Direction.Axis> axisList = new ArrayList<Direction.Axis>(List.of(Direction.Axis.values()));
        axisList.remove(face.getAxis());
        Direction.Axis widthDirection = (Direction.Axis)axisList.remove(0);
        Direction.Axis heightDirection = (Direction.Axis)axisList.remove(0);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.depth * this.height * this.width);
        for (int x = 0; x < this.depth; ++x) {
            for (int y = 1; y <= this.width; ++y) {
                for (int z = 1; z <= this.height; ++z) {
                    BlockPos.MutableBlockPos pos1 = pos.mutable();
                    pos1 = pos1.offset(face.getNormal().multiply(-x));
                    pos1 = pos1.relative(widthDirection, CubeMiningShape.intHalfInverse(y));
                    pos1 = pos1.relative(heightDirection, CubeMiningShape.intHalfInverse(z));
                    list.add((BlockPos)pos1);
                }
            }
        }
        return list;
    }

    public static int intHalfInverse(int i) {
        if (i % 2 == 0) {
            return i / 2 * -1;
        }
        return i / 2;
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

