/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.shape;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.mining.shape.MiningShape;

public class VeinMiningShape
implements MiningShape {
    public static MapCodec<VeinMiningShape> CODEC = AutoCodec.of(VeinMiningShape.class);
    public static ResourceLocation ID = Miapi.id("vein");
    public int size = 5;
    @CodecBehavior.Optional
    public int maxBlocks = 15;

    @Override
    public List<BlockPos> getMiningBlocks(Level world, BlockPos pos, Direction face) {
        ArrayList<BlockPos> miningBlocks = new ArrayList<BlockPos>();
        if (this.maxBlocks < 1) {
            return miningBlocks;
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        ArrayList<BlockPos> visited = new ArrayList<BlockPos>();
        queue.add(pos);
        visited.add(pos);
        BlockState centerState = world.getBlockState(pos);
        while (!queue.isEmpty() && miningBlocks.size() < this.size * this.size * this.size && miningBlocks.size() < this.maxBlocks) {
            BlockPos currentPos = (BlockPos)queue.poll();
            miningBlocks.add(currentPos);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = currentPos.relative(direction);
                int dx1 = neighborPos.getX() - pos.getX() + this.size;
                int dy1 = neighborPos.getY() - pos.getY() + this.size;
                int dz1 = neighborPos.getZ() - pos.getZ() + this.size;
                if (Math.abs(dx1 - this.size) > this.size || Math.abs(dy1 - this.size) > this.size || Math.abs(dz1 - this.size) > this.size || visited.contains(neighborPos)) continue;
                visited.add(neighborPos);
                BlockState neighborState = world.getBlockState(neighborPos);
                if (!neighborState.getBlock().equals(centerState.getBlock())) continue;
                queue.add(neighborPos);
            }
        }
        return miningBlocks;
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

