/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.onHit;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.event.EventResult;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class ArmorPenProperty
extends DoubleProperty {
    public static final ResourceLocation KEY = Miapi.id("armor_pen");
    public static ArmorPenProperty property;
    private static final WeakHashMap<LivingEntity, Multimap<Holder<Attribute>, AttributeModifier>> cache;

    public ArmorPenProperty() {
        super(KEY);
        property = this;
        MiapiEvents.LIVING_HURT.register(event -> {
            Entity patt0$temp = event.damageSource.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt0$temp;
                ItemStack itemStack = event.getCausingItemStack();
                Optional<Double> optionalDouble = this.getValue(itemStack);
                if (optionalDouble.isPresent()) {
                    double value = optionalDouble.get() / 100.0;
                    ArrayListMultimap multimap = ArrayListMultimap.create();
                    multimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(Miapi.id("temp_armor_pen"), -1.0 + value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                    cache.put(event.defender, (Multimap<Holder<Attribute>, AttributeModifier>)multimap);
                    event.defender.getAttributes().addTransientAttributeModifiers((Multimap)multimap);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            if (cache.containsKey(event.defender)) {
                event.defender.getAttributes().removeAttributeModifiers(cache.get(event.defender));
            }
            return EventResult.pass();
        });
    }

    static {
        cache = new WeakHashMap();
    }
}

