/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.onHit;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.events.ModularAttackEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class NemesisProperty
extends DoubleProperty
implements CraftingProperty {
    public static final ResourceLocation KEY = Miapi.id("nemesis");
    public static NemesisProperty property;
    public static Codec<NemesisData> CODEC;
    public static DataComponentType<NemesisData> NEMESIS_COMPONENT;
    public DecimalFormat modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat("##.#"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public NemesisProperty() {
        super(KEY);
        this.setupLore();
        property = this;
        EntityEvent.LIVING_DEATH.register((livingEntity, damageSource) -> {
            ItemStack weapon = MiapiEvents.LivingHurtEvent.getCausingItemStack(damageSource);
            if (ModularItem.isModularItem(weapon) && !livingEntity.level().isClientSide()) {
                double nemesisScale = this.getValue(weapon).orElse(0.0);
                if (nemesisScale == 0.0) {
                    return EventResult.pass();
                }
                NemesisData data = (NemesisData)weapon.get(NEMESIS_COMPONENT);
                EntityType attackedType = livingEntity.getType();
                if (data != null && nemesisScale > 0.0) {
                    data = data.clone();
                    Optional entityType1 = EntityType.byString((String)data.entityType);
                    if (entityType1.isPresent()) {
                        EntityType targetType = (EntityType)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            ++data.kills;
                        } else {
                            data.kills -= 5;
                            if (data.kills < 0) {
                                data.kills = 0;
                                data.entityType = "";
                            }
                        }
                    } else {
                        data.entityType = EntityType.getKey((EntityType)attackedType).toString();
                        data.kills = 1;
                    }
                } else {
                    data.entityType = EntityType.getKey((EntityType)attackedType).toString();
                    data.kills = 1;
                }
                if (livingEntity.getUseItem().equals(weapon)) {
                    weapon.set(NEMESIS_COMPONENT, (Object)data);
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.setItemInHand(player.getUsedItemHand(), weapon);
                    }
                } else {
                    weapon.set(NEMESIS_COMPONENT, (Object)data);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(listener -> {
            ItemStack weapon = listener.getCausingItemStack();
            if (ModularItem.isModularItem(weapon)) {
                double nemesisScale = this.getValue(weapon).orElse(0.0);
                NemesisData data = (NemesisData)weapon.get(NEMESIS_COMPONENT);
                if (data != null && nemesisScale > 0.0) {
                    EntityType attackedType = listener.defender.getType();
                    Optional entityType1 = EntityType.byString((String)data.entityType);
                    if (entityType1.isPresent()) {
                        EntityType targetType = (EntityType)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            listener.amount += (float)factor * listener.amount;
                        } else {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            factor = Math.min(0.95, factor);
                            listener.amount -= (float)factor * listener.amount;
                        }
                    }
                }
            }
            return EventResult.pass();
        });
        ModularAttackEvents.ATTACK_DAMAGE_BONUS.register((target, weapon, baseDamage, damageSource, bonusDamage) -> {
            if (ModularItem.isModularItem(weapon)) {
                double nemesisScale = this.getValue(weapon).orElse(0.0);
                NemesisData data = (NemesisData)weapon.get(NEMESIS_COMPONENT);
                if (data != null && nemesisScale > 0.0) {
                    EntityType attackedType = target.getType();
                    Optional entityType1 = EntityType.byString((String)data.entityType);
                    if (entityType1.isPresent()) {
                        EntityType targetType = (EntityType)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            bonusDamage.add((Number)(factor * (double)baseDamage));
                        } else {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            factor = Math.min(0.95, factor);
                            bonusDamage.add((Number)(factor * (double)baseDamage));
                        }
                    }
                }
            }
            return EventResult.pass();
        });
    }

    public void setupLore() {
        LoreProperty.loreSuppliers.add((weapon, tooltip, context, tooltipType) -> {
            double nemesisScale = this.getValue(weapon).orElse(0.0);
            NemesisData data = (NemesisData)weapon.get(NEMESIS_COMPONENT);
            if (data != null && nemesisScale > 0.0) {
                double factor = NemesisProperty.scale(data.kills, nemesisScale) * 100.0f - 1.0f;
                Optional entityType1 = EntityType.byString((String)data.entityType);
                MutableComponent entity = Component.translatable((String)"miapi.lore.nemesis.no_entity");
                if (entityType1.isPresent() && data.kills != 0) {
                    entity = ((EntityType)entityType1.get()).getDescription();
                }
                MutableComponent blueNumber = Component.literal((String)(this.modifierFormat.format(factor) + "%")).withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
                MutableComponent redNumber = Component.literal((String)(this.modifierFormat.format(factor / 2.0) + "%")).withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                MutableComponent whiteNumber = Component.literal((String)String.valueOf(data.kills)).withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE));
                entity = Component.literal((String)entity.getString()).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
                tooltip.add(Component.translatable((String)"miapi.lore.nemesis.0", (Object[])new Object[]{whiteNumber, entity}));
                if (factor != 0.0) {
                    tooltip.add(Component.translatable((String)"miapi.lore.nemesis.1", (Object[])new Object[]{blueNumber, Component.literal((String)entity.getString()).withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE))}));
                    tooltip.add(Component.translatable((String)"miapi.lore.nemesis.2", (Object[])new Object[]{redNumber, Component.literal((String)entity.getString()).withStyle(Style.EMPTY.withColor(ChatFormatting.RED))}));
                }
            }
        });
    }

    public static float scale(int rawValue, double scale) {
        double factor = (Math.log(Math.pow(rawValue + 1, 5.0)) + 1.0) * scale;
        if (rawValue < 0) {
            factor = 0.0;
        }
        return (float)factor / 100.0f;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        crafting.set(NEMESIS_COMPONENT, (Object)new NemesisData("", 0));
        return crafting;
    }

    static {
        CODEC = AutoCodec.of(NemesisData.class).codec();
        NEMESIS_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(ByteBufCodecs.fromCodec(CODEC)).build();
    }

    public static class NemesisData {
        @AutoCodec.Name(value="entity_type")
        public String entityType;
        public int kills;

        public NemesisData(String entityType, int kills) {
            this.entityType = entityType;
            this.kills = kills;
        }

        public NemesisData() {
        }

        public NemesisData clone() {
            return new NemesisData(this.entityType, this.kills);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NemesisData that = (NemesisData)o;
            return this.kills == that.kills && Objects.equals(this.entityType, that.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.entityType, this.kills);
        }
    }
}

