/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.onHit;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.MaceItem;
import smartin.miapi.Miapi;
import smartin.miapi.events.ModularAttackEvents;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class PogoAbility
extends CodecProperty<PogoData> {
    public static ResourceLocation KEY = Miapi.id("pogo_ability");
    public static PogoAbility property;

    public PogoAbility() {
        super(PogoData.CODEC);
        property = this;
        MaceItem.createAttributes();
        ModularAttackEvents.HURT_ENEMY.register((stack, target, attacker) -> {
            ServerPlayer serverPlayer;
            Optional optional = this.getData(stack);
            if (attacker instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)attacker).onGround() && optional.isPresent()) {
                ServerLevel serverLevel = (ServerLevel)attacker.level();
                if (serverPlayer.isIgnoringFallDamageFromCurrentImpulse() && serverPlayer.currentImpulseImpactPos != null) {
                    if (serverPlayer.currentImpulseImpactPos.y > serverPlayer.position().y) {
                        serverPlayer.currentImpulseImpactPos = serverPlayer.position();
                    }
                } else {
                    serverPlayer.currentImpulseImpactPos = serverPlayer.position();
                }
                serverPlayer.setIgnoreFallDamageFromCurrentImpulse(true);
                SoundEvent soundEvent = ((PogoData)optional.get()).soundEvent();
                double upwards = ((PogoData)optional.get()).resolvable().getValue();
                serverLevel.playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), soundEvent, serverPlayer.getSoundSource(), 1.0f, 1.0f);
                serverPlayer.setDeltaMovement(serverPlayer.getDeltaMovement().with(Direction.Axis.Y, 0.2 * upwards));
                serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
            return EventResult.pass();
        });
    }

    @Override
    public PogoData initialize(PogoData data, ModuleInstance moduleInstance) {
        return new PogoData(data.resolvable().initialize(moduleInstance), data.soundEvent());
    }

    @Override
    public PogoData merge(PogoData left, PogoData right, MergeType mergeType) {
        return new PogoData(left.resolvable().merge(right.resolvable(), mergeType), MergeAble.decideLeftRight(left.soundEvent(), right.soundEvent(), mergeType));
    }

    public record PogoData(DoubleOperationResolvable resolvable, SoundEvent soundEvent) {
        public static Codec<PogoData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DoubleOperationResolvable.CODEC.optionalFieldOf("strength", (Object)new DoubleOperationResolvable(1.0)).forGetter(PogoData::resolvable), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("sound", (Object)SoundEvents.EMPTY).forGetter(PogoData::soundEvent)).apply((Applicative)instance, PogoData::new));
    }
}

