/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.potion;

import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.potion.PossibleEffect;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeType;

public class OnKillEffects
extends CodecProperty<List<PossibleEffect>> {
    public static final ResourceLocation KEY = Miapi.id("on_kill_potion");
    public OnKillEffects property = this;
    public static Codec<List<PossibleEffect>> CODEC = Codec.list(PossibleEffect.CODEC);

    public OnKillEffects() {
        super(CODEC);
        EntityEvent.LIVING_DEATH.register((entity, source) -> {
            Entity patt0$temp;
            if (!entity.level().isClientSide() && (patt0$temp = source.getEntity()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)patt0$temp;
                PossibleEffect.applyEffects(livingEntity, livingEntity, i -> this.getData((ItemStack)i).orElse(new ArrayList()));
            }
            return EventResult.pass();
        });
        this.setupLore();
    }

    public void setupLore() {
        LoreProperty.loreSuppliers.add((itemStack, tooltip, context, flag) -> tooltip.addAll(PossibleEffect.getTooltip((Component)Component.translatable((String)"miapi.potion.kill.header"), this.getData(itemStack).orElse(new ArrayList()), "miapi.potion.kill.tooltip", "miapi.potion.kill.tooltip")));
    }

    @Override
    public List<PossibleEffect> merge(List<PossibleEffect> left, List<PossibleEffect> right, MergeType mergeType) {
        return PossibleEffect.merge(left, right, mergeType);
    }

    @Override
    public List<PossibleEffect> initialize(List<PossibleEffect> effects, ModuleInstance module) {
        return effects.stream().map(e -> e.initialize((PossibleEffect)e, module)).toList();
    }
}

