/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.projectile;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class DrawTimeProperty
extends DoubleProperty {
    public static final ResourceLocation KEY = Miapi.id("draw_time");
    public static DrawTimeProperty property;
    public static DecimalFormat FORMAT;

    public DrawTimeProperty() {
        super(KEY);
        property = this;
        LoreProperty.loreSuppliers.add((itemStack, tooltip, context, tooltipType) -> {
            if (this.getData(itemStack).isPresent()) {
                double drawTime = DrawTimeProperty.roundToNearest(((DoubleOperationResolvable)this.getData(itemStack).get()).getValue(), 0.05);
                tooltip.add(2, Component.translatable((String)"miapi.lore.draw_time.tooltip", (Object[])new Object[]{FORMAT.format(drawTime)}));
            }
        });
    }

    public static double roundToNearest(double value, double roundTo) {
        BigDecimal bdValue = new BigDecimal(value);
        BigDecimal bdRoundTo = new BigDecimal(roundTo);
        BigDecimal divided = bdValue.divide(bdRoundTo, 0, RoundingMode.HALF_UP);
        BigDecimal result = divided.multiply(bdRoundTo);
        return result.doubleValue();
    }

    static {
        FORMAT = new DecimalFormat("##.##");
    }
}

