/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BlockRenderModel;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class BlockModelProperty
extends CodecProperty<List<BlockModelData>> {
    public static final ResourceLocation KEY = Miapi.id("block_model");
    public static BlockModelProperty property;
    public static Codec<List<BlockModelData>> CODEC;

    public BlockModelProperty() {
        super(CODEC);
        property = this;
        MiapiItemModel.modelSuppliers.add((key, mode, model, stack) -> {
            ArrayList models = new ArrayList();
            this.getData(model).ifPresent(modelDataList -> modelDataList.forEach(blockModelData -> {
                Block block = (Block)BuiltInRegistries.BLOCK.get(blockModelData.id);
                BlockState blockState = block.defaultBlockState();
                if (blockModelData.nbt != null) {
                    blockState = BlockState.CODEC.parse(Miapi.BOOL_CORRECTED_OPS, (Object)blockModelData.nbt).result().orElse(blockState);
                }
                BlockRenderModel blockRenderModel = new BlockRenderModel(blockState, blockModelData.transform);
                if (blockModelData.spin != null) {
                    blockRenderModel.spinSettings = blockModelData.spin;
                }
                models.add(blockRenderModel);
            }));
            return models;
        });
    }

    @Override
    public List<BlockModelData> merge(List<BlockModelData> left, List<BlockModelData> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        CODEC = Codec.list((Codec)AutoCodec.of(BlockModelData.class).codec());
    }

    public class BlockModelData {
        public ResourceLocation id;
        @CodecBehavior.Optional
        public CompoundTag nbt;
        @CodecBehavior.Optional
        public Transform transform = Transform.IDENTITY;
        @CodecBehavior.Optional
        public MaterialIcons.SpinSettings spin = null;

        public BlockModelData(BlockModelProperty this$0) {
        }
    }
}

