/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.common.cache.CacheLoader;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BakedMiapiModel;
import smartin.miapi.client.model.DynamicBakery;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.model.ModelLoadAccessor;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.client.renderer.TrimRenderer;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.TransformMap;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.ColorController;
import smartin.miapi.mixin.client.ModelLoaderInterfaceAccessor;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.render.EmissivityProperty;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

@OnlyIn(value=Dist.CLIENT)
public class ModelProperty
extends CodecProperty<List<ModelData>> {
    public static ModelProperty property;
    private static final String CACHE_KEY_ITEM = "miapi:itemModelodel";
    public static final Map<String, UnbakedModelHolder> modelCache;
    public static final ResourceLocation KEY;
    public static Function<Material, TextureAtlasSprite> textureGetter;
    public static Codec<ModelData> DATA_CODEC;
    public static Codec<List<ModelData>> CODEC;

    public ModelProperty() {
        super(CODEC);
        property = this;
        ModularItemCache.setSupplier(CACHE_KEY_ITEM, stack -> ModelProperty.getModelMap(stack).get("item"));
        MiapiItemModel.modelSuppliers.add((key, mode, model, stack) -> {
            ArrayList<BakedMiapiModel> miapiModels = new ArrayList<BakedMiapiModel>();
            for (ModelHolder holder : ModelProperty.getForModule(model, key, stack)) {
                miapiModels.add(new BakedMiapiModel(holder, model, stack));
            }
            return miapiModels;
        });
    }

    public static List<ModelHolder> getForModule(ModuleInstance instance, String key, ItemStack itemStack) {
        List modelDataList = property.getData(instance).orElse(new ArrayList());
        ArrayList<ModelHolder> models = new ArrayList<ModelHolder>();
        for (ModelData json : modelDataList) {
            ModelHolder holder = ModelProperty.bakedModel(instance, json, itemStack, key);
            if (holder == null) continue;
            models.add(holder);
        }
        return models;
    }

    @Nullable
    public static ModelHolder bakedModel(ModuleInstance instance, ModelData json, ItemStack itemStack, String key) {
        int condition = ColorController.getColor(StatResolver.resolveString(json.condition, instance));
        if (condition != 0 && (json.transform.origin == null && "item".equals(key) || json.transform.origin != null && json.transform.origin.equals(key) || "item".equals(json.transform.origin) && key == null)) {
            return ModelProperty.bakedModel(instance, json, itemStack);
        }
        return null;
    }

    @Nullable
    public static ModelHolder bakedModel(ModuleInstance instance, ModelData json, ItemStack itemStack) {
        BakedSingleModel model;
        smartin.miapi.material.base.Material material = MaterialProperty.getMaterial(instance);
        json.repair();
        List<String> list = new ArrayList<String>();
        if (material != null) {
            list.add(material.getStringID());
            list = material.getTextureKeys();
        } else {
            list.add("default");
        }
        UnbakedModelHolder unbakedModel = null;
        for (String str : list) {
            String fullPath = json.path.replace("[material.texture]", str);
            if (!modelCache.containsKey(fullPath)) continue;
            unbakedModel = modelCache.get(fullPath);
            break;
        }
        if (unbakedModel == null) {
            String fullPath = json.path.replace("[material.texture]", "default");
            if (modelCache.containsKey(fullPath)) {
                unbakedModel = modelCache.get(fullPath);
            } else {
                return null;
            }
        }
        if ((model = DynamicBakery.bakeModel(unbakedModel.model, textureGetter, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255), Transform.IDENTITY)) != null) {
            int[] nArray;
            Matrix4f matrix4f = Transform.toModelTransformation(json.transform).toMatrix();
            String colorProviderId = unbakedModel.modelMetadata.colorProvider != null ? unbakedModel.modelMetadata.colorProvider : json.color_provider;
            ColorProvider colorProvider = ColorProvider.getProvider(colorProviderId, itemStack, instance);
            if (colorProvider == null) {
                throw new RuntimeException("colorProvider is null");
            }
            BakedModel bakedModel = model.optimize();
            if (unbakedModel.modelMetadata.lightValues == null) {
                int[] nArray2 = new int[2];
                nArray2[0] = -1;
                nArray = nArray2;
                nArray2[1] = -1;
            } else {
                nArray = unbakedModel.modelMetadata.lightValues;
            }
            return new ModelHolder(bakedModel, matrix4f, colorProvider, nArray, json.getTrimMode(), json.entity_render);
        }
        return null;
    }

    public static boolean isAllowedKey(@Nullable String jsonKey, @Nullable String modelTypeKey) {
        return jsonKey == null && modelTypeKey == null || jsonKey != null && jsonKey.equals(modelTypeKey) || jsonKey != null && modelTypeKey == null && jsonKey.equals("default") || jsonKey == null && modelTypeKey != null && modelTypeKey.equals("default") || "item".equals(modelTypeKey) && "default".equals(jsonKey) || "item".equals(jsonKey) && modelTypeKey == null;
    }

    public static Map<String, BakedModel> getModelMap(ItemStack stack) {
        return new HashMap<String, BakedModel>();
    }

    @Nullable
    public static BakedModel getItemModel(ItemStack stack) {
        return (BakedModel)ModularItemCache.getRaw(stack, CACHE_KEY_ITEM);
    }

    protected static BlockModel loadModelFromFilePath(String filePath2) throws FileNotFoundException {
        if (modelCache.containsKey(filePath2)) {
            return ModelProperty.modelCache.get((Object)filePath2).model;
        }
        if (!((String)filePath2).endsWith(".json")) {
            filePath2 = (String)filePath2 + ".json";
        }
        if (((String)filePath2).contains("item/") && !((String)filePath2).contains("models/")) {
            filePath2 = ((String)filePath2).replace("item/", "models/item/");
        }
        ModelBakery loader = ModelLoadAccessor.getLoader();
        filePath2 = ((String)filePath2).replace(".json", "");
        filePath2 = ((String)filePath2).replace("models/", "");
        ResourceLocation modelId = ResourceLocation.parse((String)filePath2);
        BlockModel model = ((ModelLoaderInterfaceAccessor)loader).loadModelFromPath(modelId);
        if (!((String)filePath2).endsWith(".json")) {
            filePath2 = (String)filePath2 + ".json";
        }
        if (((String)filePath2).contains("item/") && !((String)filePath2).contains("models/")) {
            filePath2 = ((String)filePath2).replace("item/", "models/item/");
        }
        UnbakedModelHolder holder = new UnbakedModelHolder(model, ModelProperty.fromPath(ModelBakery.MODEL_LISTER.idToFile(modelId)));
        modelCache.put((String)filePath2, holder);
        modelCache.put(modelId.toString(), holder);
        model.getOverrides().forEach(modelOverride -> {
            try {
                ModelProperty.loadModelFromFilePath(modelOverride.getModel().toString());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        ModelProperty.loadTextureDependencies(model);
        return model;
    }

    public static ModelMetadata fromPath(ResourceLocation identifier) {
        try {
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(identifier);
            if (resource.isPresent()) {
                return ((Resource)resource.get()).metadata().getSection((MetadataSectionSerializer)new ModelDecoder()).orElse(ModelDecoder.EMPTY());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ModelDecoder.EMPTY();
    }

    protected static void loadModelsByPath(String filePath) {
        String materialKey = "[material.texture]";
        HashMap<String, BlockModel> models = new HashMap<String, BlockModel>();
        if (filePath.contains(materialKey)) {
            try {
                String path2 = filePath.replace(materialKey, "default");
                BlockModel model = ModelProperty.loadModelFromFilePath(path2);
                models.put("default", model);
            }
            catch (CacheLoader.InvalidCacheLoadException | FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
            MaterialProperty.getTextureKeys().forEach(path -> {
                try {
                    String fullPath = filePath.replace(materialKey, (CharSequence)path);
                    BlockModel model = ModelProperty.loadModelFromFilePath(fullPath);
                    if (model != null) {
                        models.put((String)path, model);
                    }
                }
                catch (CacheLoader.InvalidCacheLoadException | FileNotFoundException throwable) {
                    // empty catch block
                }
            });
        } else {
            try {
                BlockModel model = ModelProperty.loadModelFromFilePath(filePath);
                models.put("default", model);
            }
            catch (CacheLoader.InvalidCacheLoadException | FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        }
    }

    protected static void loadTextureDependencies(BlockModel model) {
        DynamicBakery.bakeModel(model, identifier -> textureGetter.apply((Material)identifier), 0, Transform.IDENTITY);
    }

    @Override
    public boolean load(ResourceLocation moduleKey, JsonElement data, boolean isClient) throws Exception {
        ((List)this.decode(data)).forEach(modelData -> {
            modelData.repair();
            ModelProperty.loadModelsByPath(modelData.path);
        });
        return true;
    }

    @Override
    public List<ModelData> merge(List<ModelData> left, List<ModelData> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        modelCache = new HashMap<String, UnbakedModelHolder>();
        KEY = Miapi.id("model");
        DATA_CODEC = ModelData.CODEC;
        CODEC = Codec.withAlternative((Codec)Codec.list(DATA_CODEC), (Codec)new Codec<List<ModelData>>(){

            public <T> DataResult<Pair<List<ModelData>, T>> decode(DynamicOps<T> ops, T input) {
                DataResult result = DATA_CODEC.decode(ops, input);
                if (result.isSuccess()) {
                    Pair success = (Pair)result.getOrThrow();
                    return DataResult.success((Object)new Pair(List.of((ModelData)success.getFirst()), success.getSecond()));
                }
                return DataResult.error(() -> "could not decode as single entry");
            }

            public <T> DataResult<T> encode(List<ModelData> input, DynamicOps<T> ops, T prefix) {
                return Codec.list(DATA_CODEC).encode(input, ops, prefix);
            }
        });
    }

    public static class ModelData {
        public String path;
        public Transform transform = Transform.IDENTITY;
        public String condition = "1";
        public String color_provider = "material";
        public String trim_mode = "none";
        public Boolean entity_render = false;
        public String id = null;
        public static final Codec<ModelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("path").forGetter(modelData -> modelData.path), (App)Transform.CODEC.optionalFieldOf("transform", (Object)Transform.IDENTITY).forGetter(modelData -> modelData.transform), (App)Codec.STRING.optionalFieldOf("condition", (Object)"1").forGetter(modelData -> modelData.condition), (App)Codec.STRING.optionalFieldOf("color_provider", (Object)"material").forGetter(modelData -> modelData.color_provider), (App)Codec.STRING.optionalFieldOf("trim_mode", (Object)"none").forGetter(modelData -> modelData.trim_mode), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("entity_render").forGetter(modelData -> Optional.of(modelData.entity_render)), (App)Codec.STRING.optionalFieldOf("id", (Object)"").forGetter(modelData -> modelData.id)).apply((Applicative)instance, ModelData::new));

        public ModelData(String path, Transform transform, String condition, String color_provider, String trim_mode, Optional<Boolean> entity_render, String id) {
            this.path = path;
            this.transform = transform;
            this.condition = condition;
            this.color_provider = color_provider;
            this.trim_mode = trim_mode;
            this.entity_render = entity_render.orElseGet(() -> this.getTrimMode().equals((Object)TrimRenderer.TrimMode.ARMOR_LAYER_ONE) || this.getTrimMode().equals((Object)TrimRenderer.TrimMode.ARMOR_LAYER_TWO));
            this.id = id;
            this.repair();
        }

        public void repair() {
            if (this.transform == null) {
                this.transform = Transform.IDENTITY;
            }
            this.transform = Transform.repair(this.transform);
        }

        public TrimRenderer.TrimMode getTrimMode() {
            if (this.trim_mode == null) {
                return TrimRenderer.TrimMode.NONE;
            }
            return switch (this.trim_mode.toLowerCase()) {
                case "armor_layer_one" -> TrimRenderer.TrimMode.ARMOR_LAYER_ONE;
                case "armor_layer_two" -> TrimRenderer.TrimMode.ARMOR_LAYER_TWO;
                case "item" -> TrimRenderer.TrimMode.ITEM;
                default -> TrimRenderer.TrimMode.NONE;
            };
        }
    }

    public record UnbakedModelHolder(BlockModel model, ModelMetadata modelMetadata) {
    }

    public record ModelMetadata(String colorProvider, int[] lightValues) {
    }

    static class ModelDecoder
    implements MetadataSectionSerializer<ModelMetadata> {
        ModelDecoder() {
        }

        public static ModelMetadata EMPTY() {
            return new ModelMetadata(null, null);
        }

        @NotNull
        public String getMetadataSectionName() {
            return "miapi_model_data";
        }

        @NotNull
        public ModelMetadata fromJson(JsonObject json) {
            String data = null;
            int[] light = null;
            if (json.has("modelProvider") && !ColorProvider.colorProviders.containsKey(data = json.get("modelProvider").getAsString())) {
                Miapi.LOGGER.error("Color Provider " + data + " does not exist");
                data = null;
            }
            if (json.has("lightValues")) {
                EmissivityProperty.LightJson lightJson = (EmissivityProperty.LightJson)EmissivityProperty.property.decode(json.get("lightValues"));
                light = lightJson.asArray();
            }
            return new ModelMetadata(data, light);
        }
    }

    public record TransformedUnbakedModel(TransformMap transform, BlockModel unbakedModel, ModuleInstance instance, int color) {
    }
}

