/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeType;

@OnlyIn(value=Dist.CLIENT)
public class ModelTransformationProperty
extends CodecProperty<ModelTransformationData> {
    public static final ResourceLocation KEY = Miapi.id("model_transform");
    public static ModelTransformationProperty property;

    public ModelTransformationProperty() {
        super(AutoCodec.of(ModelTransformationData.class).codec());
        property = this;
        MiapiItemModel.modelTransformersSuppler.add((itemStack, modelType, itemDisplayContext) -> {
            ModelTransformationData data = property.getData(itemStack).orElseGet(ModelTransformationData::new);
            ItemTransform transforms = data.asItemTransforms().getTransform(itemDisplayContext);
            if (transforms != null) {
                return (matrices, tickDelta) -> {
                    ModelTransformationProperty.applyTransformation(transforms, data.fix_left && ModelTransformationProperty.isLeftHanded(itemDisplayContext), matrices);
                    return matrices;
                };
            }
            return null;
        });
    }

    public static void applyTransformation(ItemTransform transformation, boolean fixLeft, PoseStack matrices) {
        matrices.translate(0.5f, 0.5f, 0.5f);
        if (transformation != null) {
            transformation.apply(fixLeft, matrices);
        }
        matrices.translate(-0.5f, -0.5f, -0.5f);
    }

    public static ItemTransforms getTransformation(ItemStack stack) {
        return property.getData(stack).orElseGet(ModelTransformationData::new).asItemTransforms();
    }

    public static boolean isLeftHanded(ItemDisplayContext mode) {
        return switch (mode) {
            case ItemDisplayContext.THIRD_PERSON_LEFT_HAND, ItemDisplayContext.FIRST_PERSON_LEFT_HAND -> true;
            default -> false;
        };
    }

    public static Transform makeLeft(Transform transform) {
        transform = transform.copy();
        transform.translation.set((Vector3fc)new Vector3f(-transform.translation.x(), transform.translation.y(), transform.translation.z()));
        Matrix4f m = transform.toMatrix();
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f));
        Transform rotated = Transform.fromMatrix(m);
        rotated.origin = transform.origin;
        return rotated;
    }

    private static Set<String> getStringOfMode(ItemDisplayContext mode) {
        ArrayList<String> modes = new ArrayList<String>();
        modes.add(mode.toString());
        modes.add(mode.toString().replace("_", ""));
        modes.add(mode.toString().toLowerCase());
        modes.add(mode.toString().toLowerCase().replace("_", ""));
        switch (mode) {
            case GUI: {
                modes.add("gui");
                break;
            }
            case HEAD: {
                modes.add("head");
                break;
            }
            case FIXED: {
                modes.add("fixed");
                break;
            }
            case GROUND: {
                modes.add("ground");
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                modes.add("firstperson_lefthand");
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                modes.add("firstperson_righthand");
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                modes.add("thirdperson_lefthand");
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                modes.add("thirdperson_righthand");
            }
        }
        return Set.copyOf(modes);
    }

    @Override
    public ModelTransformationData merge(ModelTransformationData left, ModelTransformationData right, MergeType mergeType) {
        return ModelTransformationData.merge(left, right, mergeType);
    }

    public static class ModelTransformationData {
        @CodecBehavior.Optional
        public Transform gui = null;
        @CodecBehavior.Optional
        public Transform head = null;
        @CodecBehavior.Optional
        public Transform fixed = null;
        @CodecBehavior.Optional
        public Transform ground = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="firstperson_lefthand")
        public Transform firstPersonLeftHand = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="firstperson_righthand")
        public Transform firstPersonRightHand = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="thirdperson_lefthand")
        public Transform thirdPersonLeftHand = null;
        @CodecBehavior.Optional
        @AutoCodec.Name(value="thirdperson_righthand")
        public Transform thirdPersonRightHand = null;
        @CodecBehavior.Optional
        public boolean overwrite = true;
        @CodecBehavior.Optional
        public boolean fix_left = false;

        public static ModelTransformationData merge(ModelTransformationData left, ModelTransformationData right, MergeType mergeType) {
            ModelTransformationData data = new ModelTransformationData();
            if (right.overwrite) {
                data.gui = ModelTransformationData.overwrite(left.gui, right.gui);
                data.head = ModelTransformationData.overwrite(left.head, right.head);
                data.fixed = ModelTransformationData.overwrite(left.fixed, right.fixed);
                data.ground = ModelTransformationData.overwrite(left.ground, right.ground);
                data.firstPersonLeftHand = ModelTransformationData.overwrite(left.firstPersonLeftHand, right.firstPersonLeftHand);
                data.firstPersonRightHand = ModelTransformationData.overwrite(left.firstPersonRightHand, right.firstPersonRightHand);
                data.thirdPersonLeftHand = ModelTransformationData.overwrite(left.thirdPersonLeftHand, right.thirdPersonLeftHand);
                data.thirdPersonRightHand = ModelTransformationData.overwrite(left.thirdPersonRightHand, right.thirdPersonRightHand);
                data.fix_left = right.fix_left;
            } else {
                data.gui = ModelTransformationData.merge(left.gui, right.gui);
                data.head = ModelTransformationData.merge(left.head, right.head);
                data.fixed = ModelTransformationData.merge(left.fixed, right.fixed);
                data.ground = ModelTransformationData.merge(left.ground, right.ground);
                data.firstPersonLeftHand = ModelTransformationData.merge(left.firstPersonLeftHand, right.firstPersonLeftHand);
                data.firstPersonRightHand = ModelTransformationData.merge(left.firstPersonRightHand, right.firstPersonRightHand);
                data.thirdPersonLeftHand = ModelTransformationData.merge(left.thirdPersonLeftHand, right.thirdPersonLeftHand);
                data.thirdPersonRightHand = ModelTransformationData.merge(left.thirdPersonRightHand, right.thirdPersonRightHand);
                data.fix_left = left.fix_left;
            }
            return data;
        }

        public static Transform merge(@Nullable Transform left, @Nullable Transform right) {
            if (left == null && right == null) {
                return null;
            }
            if (left != null && right == null) {
                return left.copy();
            }
            if (left == null && right != null) {
                return right.copy();
            }
            return Transform.merge(left, right);
        }

        public static Transform overwrite(@Nullable Transform left, @Nullable Transform right) {
            if (right == null) {
                return left != null ? left.copy() : null;
            }
            return right.copy();
        }

        public ItemTransforms asItemTransforms() {
            return new ItemTransforms(this.thirdPersonLeftHand != null ? this.thirdPersonLeftHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.thirdPersonRightHand != null ? this.thirdPersonRightHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.firstPersonLeftHand != null ? this.firstPersonLeftHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.firstPersonRightHand != null ? this.firstPersonRightHand.toTransformation() : Transform.IDENTITY.toTransformation(), this.head != null ? this.head.toTransformation() : Transform.IDENTITY.toTransformation(), this.gui != null ? this.gui.toTransformation() : Transform.IDENTITY.toTransformation(), this.ground != null ? this.ground.toTransformation() : Transform.IDENTITY.toTransformation(), this.fixed != null ? this.fixed.toTransformation() : Transform.IDENTITY.toTransformation());
        }
    }
}

