/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render.colorproviders;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.util.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;

public interface ColorProvider {
    public static final Map<String, ColorProvider> colorProviders = new HashMap<String, ColorProvider>();

    public static void setup() {
        colorProviders.put("material", new MaterialColorProvider());
        colorProviders.put("model", new ModelColorProvider());
        colorProviders.put("potion", new PotionColorProvider());
        colorProviders.put("parent", new ParentColorProvider());
        colorProviders.put("item.material", new ItemMaterialColorProvider());
    }

    public static ColorProvider getProvider(String type, ItemStack itemStack, ModuleInstance moduleInstance) {
        ColorProvider base = colorProviders.getOrDefault(type, colorProviders.get("material"));
        return base.getInstance(itemStack, base.adapt(moduleInstance));
    }

    default public Optional<Color> getVertexColor() {
        return Optional.empty();
    }

    default public ModuleInstance adapt(ModuleInstance moduleInstance) {
        return moduleInstance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public VertexConsumer getConsumer(MultiBufferSource var1, TextureAtlasSprite var2, ItemStack var3, ModuleInstance var4, ItemDisplayContext var5);

    public ColorProvider getInstance(ItemStack var1, ModuleInstance var2);

    public static class MaterialColorProvider
    implements ColorProvider {
        public Material material;

        public MaterialColorProvider() {
        }

        public MaterialColorProvider(Material material) {
            this.material = material;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ModuleInstance moduleInstance, ItemDisplayContext mode) {
            if (this.material == null) {
                return vertexConsumers.getBuffer(ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true));
            }
            return this.material.getRenderController(moduleInstance, mode).getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ModuleInstance instance) {
            Material material1 = MaterialProperty.getMaterial(instance);
            if (material1 != null) {
                return new MaterialColorProvider(material1);
            }
            return new ModelColorProvider();
        }
    }

    public static class ModelColorProvider
    implements ColorProvider {
        public ModelColorProvider() {
        }

        public ModelColorProvider(ItemStack stack) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ModuleInstance moduleInstance, ItemDisplayContext mode) {
            return vertexConsumers.getBuffer(ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true));
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ModuleInstance instance) {
            return new ModelColorProvider(stack);
        }
    }

    public static class PotionColorProvider
    implements ColorProvider {
        Color potioncolor;

        public PotionColorProvider() {
        }

        public PotionColorProvider(ItemStack stack) {
            this.potioncolor = !stack.has(DataComponents.POTION_CONTENTS) ? Color.WHITE : new Color(((PotionContents)stack.getComponents().get(DataComponents.POTION_CONTENTS)).getColor());
        }

        @Override
        public Optional<Color> getVertexColor() {
            return Optional.of(this.potioncolor);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ModuleInstance moduleInstance, ItemDisplayContext mode) {
            return vertexConsumers.getBuffer(ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true));
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ModuleInstance instance) {
            return new PotionColorProvider(stack);
        }
    }

    public static class ParentColorProvider
    extends MaterialColorProvider {
        public Material material;

        public ParentColorProvider() {
        }

        public ParentColorProvider(Material material) {
            this.material = material;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ModuleInstance moduleInstance, ItemDisplayContext mode) {
            return this.material.getRenderController(moduleInstance, mode).getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ModuleInstance instance) {
            Material material1 = MaterialProperty.getMaterial(instance);
            if (material1 != null) {
                return new ItemMaterialColorProvider(material1);
            }
            return new ModelColorProvider();
        }

        @Override
        public ModuleInstance adapt(ModuleInstance moduleInstance) {
            if (moduleInstance.parent != null) {
                return moduleInstance.parent;
            }
            return moduleInstance;
        }
    }

    public static class ItemMaterialColorProvider
    extends MaterialColorProvider {
        public Material material;
        public Material actualMaterial;

        public ItemMaterialColorProvider() {
        }

        public ItemMaterialColorProvider(Material material) {
            this.material = material;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ModuleInstance moduleInstance, ItemDisplayContext mode) {
            if (this.actualMaterial == null) {
                this.actualMaterial = MaterialProperty.getMaterialFromIngredient(stack);
            }
            if (this.actualMaterial != null) {
                return this.actualMaterial.getRenderController(moduleInstance, mode).getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
            }
            return this.material.getRenderController(moduleInstance, mode).getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ModuleInstance instance) {
            Material material1 = MaterialProperty.getMaterialFromIngredient(stack);
            if (material1 != null) {
                return new ItemMaterialColorProvider(material1);
            }
            return new ModelColorProvider();
        }
    }
}

