/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.modules.properties.util.Validator;
import smartin.miapi.registries.RegistryInventory;

public abstract class CodecProperty<T>
implements ModuleProperty<T>,
Validator<T> {
    protected final Codec<T> codec;
    public static RegistryOps<JsonElement> ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
    public static DynamicOps<JsonElement> jsonOPs = JsonOps.INSTANCE;

    public static RegistryOps<JsonElement> getOps() {
        if (Miapi.registryAccess != null) {
            return RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Miapi.registryAccess);
        }
        return ops;
    }

    @Override
    public boolean load(ResourceLocation id, JsonElement element, boolean isClient) throws Exception {
        T decoded = this.decode(element);
        for (EditorError editorError : this.validate(0, decoded, isClient)) {
            if (editorError.severity() == EditorError.ErrorSeverity.INFO) {
                Miapi.LOGGER.info(String.valueOf(RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.findKey(this)) + " from " + String.valueOf(id) + " : " + editorError.message());
                Miapi.LOGGER.info(String.valueOf(element));
                continue;
            }
            if (editorError.severity() == EditorError.ErrorSeverity.WARNING) {
                Miapi.LOGGER.warn(String.valueOf(RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.findKey(this)) + " from " + String.valueOf(id) + " : " + editorError.message());
                Miapi.LOGGER.warn(String.valueOf(element));
                continue;
            }
            if (editorError.severity() != EditorError.ErrorSeverity.ERROR) continue;
            Miapi.LOGGER.error(String.valueOf(RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.findKey(this)) + " from " + String.valueOf(id) + " : " + editorError.message());
            Miapi.LOGGER.error(String.valueOf(element));
        }
        return true;
    }

    @Override
    public List<EditorError> validate(int line, T property, boolean isClient) {
        return List.of();
    }

    protected CodecProperty(Codec<T> codec) {
        this.codec = codec;
    }

    @Override
    public T decode(JsonElement element) {
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
        if (Miapi.registryAccess != null) {
            ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)Miapi.registryAccess);
        }
        return (T)this.codec.parse((DynamicOps)ops, (Object)((Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.INSTANCE, element))).getOrThrow(s -> new DecoderException("could not decode CodecProperty " + this.getClass().getName() + " " + s));
    }

    @OnlyIn(value=Dist.CLIENT)
    private RegistryOps<JsonElement> clientCodec() {
        return RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Minecraft.getInstance().getConnection().registryAccess());
    }

    @Override
    public JsonElement encode(T property) {
        DataResult result = this.codec.encodeStart(CodecProperty.getOps(), property);
        if (result.isError()) {
            throw new EncoderException("Could not Encode " + this.getClass().getName() + " with Error " + result.error().toString());
        }
        return (JsonElement)result.getOrThrow();
    }
}

