/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.SourceSetter;

public class DoubleOperationResolvable
implements SourceSetter<DoubleOperationResolvable> {
    static Codec<Operation> autoCodec = AutoCodec.of(Operation.class).codec();
    static Codec<Operation> operationCodec = Codec.withAlternative((Codec)new Codec<Operation>(){

        public <T> DataResult<T> encode(Operation input, DynamicOps<T> ops, T prefix) {
            return autoCodec.encode((Object)input, ops, prefix);
        }

        public <T> DataResult<Pair<Operation, T>> decode(DynamicOps<T> ops, T input) {
            DataResult result = Operation.NUMBERSTRINGCODEC.decode(ops, input);
            if (result.isError()) {
                DataResult doubleResult = Codec.DOUBLE.decode(ops, input);
                if (doubleResult.isSuccess()) {
                    Pair doubleTPair = (Pair)doubleResult.getOrThrow();
                    return DataResult.success((Object)new Pair((Object)new Operation(String.valueOf(doubleTPair.getFirst())), doubleTPair.getSecond()));
                }
                return DataResult.error(() -> "is neither a string nor a boolean or a number");
            }
            Pair stringTPair = (Pair)result.getOrThrow();
            return DataResult.success((Object)new Pair((Object)new Operation((String)stringTPair.getFirst()), stringTPair.getSecond()));
        }
    }, autoCodec);
    static Codec<List<Operation>> listCodec = Codec.list(operationCodec);
    public static Codec<DoubleOperationResolvable> CODEC = Codec.withAlternative((Codec)new Codec<DoubleOperationResolvable>(){

        public <T> DataResult<T> encode(DoubleOperationResolvable input, DynamicOps<T> ops, T prefix) {
            return listCodec.encode(input.operations, ops, prefix);
        }

        public <T> DataResult<Pair<DoubleOperationResolvable, T>> decode(DynamicOps<T> ops, T input) {
            DataResult result = operationCodec.decode(ops, input);
            if (result.isError()) {
                return DataResult.error(() -> "could not decode double operations");
            }
            Pair pair = (Pair)result.getOrThrow();
            return DataResult.success((Object)new Pair((Object)new DoubleOperationResolvable(List.of((Operation)pair.getFirst())), pair.getSecond()));
        }
    }, (Codec)new Codec<DoubleOperationResolvable>(){

        public <T> DataResult<T> encode(DoubleOperationResolvable input, DynamicOps<T> ops, T prefix) {
            return listCodec.encode(input.operations, ops, prefix);
        }

        public <T> DataResult<Pair<DoubleOperationResolvable, T>> decode(DynamicOps<T> ops, T input) {
            Pair pair = (Pair)listCodec.decode(ops, input).getOrThrow(e -> new RuntimeException(e + "could not decode double operations"));
            return DataResult.success((Object)new Pair((Object)new DoubleOperationResolvable((List)pair.getFirst()), pair.getSecond()));
        }
    });
    public List<Operation> operations;
    protected Function<Pair<String, ModuleInstance>, String> functionTransformer = Pair::getFirst;
    Double cachedResult = null;
    double baseValue = 0.0;
    double fallback = 0.0;
    ModuleInstance initialized;

    public DoubleOperationResolvable(double fallback) {
        this.fallback = fallback;
        this.operations = new ArrayList<Operation>();
    }

    public DoubleOperationResolvable(List<Operation> operations) {
        this.operations = operations;
    }

    protected DoubleOperationResolvable(List<Operation> operations, Function<Pair<String, ModuleInstance>, String> functionTransformer) {
        this.operations = operations;
        this.functionTransformer = functionTransformer;
    }

    public double getValue() {
        return this.evaluate(this.baseValue, this.fallback);
    }

    public void setFunctionTransformer(Function<Pair<String, ModuleInstance>, String> functionTransformer) {
        this.functionTransformer = functionTransformer;
        for (Operation operation : this.operations) {
            operation.transformer = this.functionTransformer;
        }
        this.cachedResult = null;
    }

    public Function<Pair<String, ModuleInstance>, String> getFunctionTransformer() {
        return this.functionTransformer;
    }

    public DoubleOperationResolvable initialize(ModuleInstance moduleInstance) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        if (this.operations != null) {
            this.operations.forEach(operation -> {
                Operation copiesOperation = new Operation(operation.value);
                copiesOperation.attributeOperation = operation.attributeOperation;
                copiesOperation.instance = moduleInstance;
                copiesOperation.transformer = this.functionTransformer;
                copiesOperation.source = operation.source;
                operationList.add(copiesOperation);
            });
        }
        DoubleOperationResolvable initialized = new DoubleOperationResolvable(operationList, this.functionTransformer);
        initialized.fallback = this.fallback;
        initialized.getValue();
        initialized.initialized = moduleInstance;
        return initialized;
    }

    public double evaluate(double baseValue, double fallback) {
        return this.evaluate(baseValue).orElse(fallback);
    }

    public void clearCache() {
        this.cachedResult = null;
    }

    public Optional<Double> evaluate(double baseValue) {
        if (this.cachedResult == null || baseValue != this.baseValue) {
            DoubleOperationResolvable.resolve(this.operations, baseValue).ifPresent(result -> {
                this.cachedResult = result;
            });
        }
        return Optional.ofNullable(this.cachedResult);
    }

    public static double resolve(List<Operation> operations, double baseValue, double fallback) {
        return DoubleOperationResolvable.resolve(operations, baseValue).orElse(fallback);
    }

    public static Optional<Double> resolve(List<Operation> operations, double baseValue) {
        double value = baseValue;
        boolean hasValue = false;
        ArrayList<Double> addition = new ArrayList<Double>();
        ArrayList<Double> multiplyBase = new ArrayList<Double>();
        ArrayList<Double> multiplyTotal = new ArrayList<Double>();
        for (Operation operation : operations) {
            hasValue = true;
            switch (operation.attributeOperation) {
                case ADD_VALUE: {
                    addition.add(operation.solve());
                    break;
                }
                case ADD_MULTIPLIED_BASE: {
                    multiplyBase.add(operation.solve());
                    break;
                }
                case ADD_MULTIPLIED_TOTAL: {
                    multiplyTotal.add(operation.solve());
                }
            }
        }
        for (Double currentValue : addition) {
            value += currentValue.doubleValue();
        }
        double multiplier = 1.0;
        for (Double currentValue : multiplyBase) {
            multiplier += currentValue.doubleValue();
        }
        value *= multiplier;
        for (Double currentValue : multiplyTotal) {
            value = (currentValue + 1.0) * value;
        }
        if (hasValue) {
            if (Double.isNaN(value)) {
                Miapi.LOGGER.error("could not correctly resolve Double Operations. this indicates a serious issue");
                return Optional.empty();
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean isTrue() {
        return this.getValue() > 0.0;
    }

    public DoubleOperationResolvable merge(DoubleOperationResolvable left, MergeType mergeType) {
        return DoubleOperationResolvable.merge(this, left, mergeType);
    }

    public static DoubleOperationResolvable merge(DoubleOperationResolvable left, DoubleOperationResolvable right, MergeType mergeType) {
        Function<Pair<String, ModuleInstance>, String> functionTransformer = right.functionTransformer;
        if (MergeType.OVERWRITE.equals((Object)mergeType)) {
            return right;
        }
        if (MergeType.EXTEND.equals((Object)mergeType)) {
            functionTransformer = left.functionTransformer;
        }
        ArrayList<Operation> operationList = new ArrayList<Operation>(left.operations);
        operationList.addAll(right.operations);
        DoubleOperationResolvable resolvable = new DoubleOperationResolvable(operationList, functionTransformer);
        if (left.initialized != null) {
            resolvable.initialize(left.initialized);
        }
        return new DoubleOperationResolvable(operationList, functionTransformer);
    }

    @Override
    public DoubleOperationResolvable setSource(DoubleOperationResolvable data, Component source) {
        data.operations.forEach(op -> {
            op.source = Optional.of(source);
        });
        return data;
    }

    public static class Operation {
        public static Codec<AttributeModifier.Operation> operationCodec = new Codec<AttributeModifier.Operation>(){

            public <T> DataResult<Pair<AttributeModifier.Operation, T>> decode(DynamicOps<T> ops, T input) {
                Pair stringTPair = (Pair)Codec.STRING.decode(ops, input).getOrThrow();
                AttributeModifier.Operation operations = Operation.getOperation((String)stringTPair.getFirst());
                return DataResult.success((Object)new Pair((Object)operations, stringTPair.getSecond()));
            }

            public <T> DataResult<T> encode(AttributeModifier.Operation input, DynamicOps<T> ops, T prefix) {
                return Codec.STRING.encode((Object)Operation.toCodecString(input), ops, prefix);
            }
        };
        public static Codec<String> NUMBERSTRINGCODEC = new Codec<String>(){

            public <T> DataResult<Pair<String, T>> decode(DynamicOps<T> ops, T input) {
                DataResult numberResult = ops.getNumberValue(input);
                if (numberResult.isSuccess()) {
                    return DataResult.success((Object)new Pair((Object)((Number)numberResult.getOrThrow()).toString(), input));
                }
                DataResult boolResult = ops.getBooleanValue(input);
                if (boolResult.isSuccess()) {
                    return DataResult.success((Object)new Pair((Object)((Boolean)boolResult.getOrThrow() != false ? "1" : "-1"), input));
                }
                DataResult stringResult = ops.getStringValue(input);
                if (stringResult.isSuccess()) {
                    if (((String)stringResult.getOrThrow()).equals("true")) {
                        return DataResult.success((Object)new Pair((Object)"1", input));
                    }
                    if (((String)stringResult.getOrThrow()).equals("false")) {
                        return DataResult.success((Object)new Pair((Object)"-1", input));
                    }
                    return DataResult.success((Object)new Pair((Object)((String)stringResult.getOrThrow()), input));
                }
                DataResult decodeDouble = Codec.DOUBLE.decode(ops, input);
                if (decodeDouble.isSuccess()) {
                    Pair doubleTPair = (Pair)decodeDouble.getOrThrow();
                    return DataResult.success((Object)new Pair((Object)String.valueOf(doubleTPair.getFirst()), input));
                }
                DataResult decodeString = Codec.STRING.decode(ops, input);
                if (decodeString.isSuccess()) {
                    Pair pair = (Pair)decodeString.getOrThrow();
                    return DataResult.success((Object)new Pair((Object)((String)pair.getFirst()), input));
                }
                DataResult decodeBoolean = Miapi.FIXED_BOOL_CODEC.decode(ops, input);
                if (decodeBoolean.isSuccess()) {
                    return DataResult.success((Object)new Pair((Object)((Boolean)((Pair)decodeBoolean.getOrThrow()).getFirst() != false ? "1" : "-1"), input));
                }
                return DataResult.error(() -> "is neither a string nor a boolean or a number");
            }

            public <T> DataResult<T> encode(String input, DynamicOps<T> ops, T prefix) {
                return Codec.STRING.encode((Object)input, ops, prefix);
            }
        };
        @AutoCodec.Name(value="operation")
        @CodecBehavior.Override(value="operationCodec")
        public AttributeModifier.Operation attributeOperation = AttributeModifier.Operation.ADD_VALUE;
        @AutoCodec.Name(value="value")
        @CodecBehavior.Override(value="NUMBERSTRINGCODEC")
        public String value;
        @AutoCodec.Ignored
        public ModuleInstance instance;
        @AutoCodec.Ignored
        public Function<Pair<String, ModuleInstance>, String> transformer = Pair::getFirst;
        @AutoCodec.Ignored
        public Optional<Component> source = Optional.empty();

        public Operation() {
            this.value = "1";
        }

        public Operation(double value, AttributeModifier.Operation operation) {
            this.value = String.valueOf(value);
            this.attributeOperation = operation;
        }

        public Operation(String value) {
            this.value = value;
        }

        public double solve() {
            if (this.instance == null) {
                IllegalAccessError error = new IllegalAccessError("Double Resolvable was resolved before initialized!");
                Miapi.LOGGER.error("Double Resolvable was never initialized!", (Throwable)error);
                return 0.0;
            }
            String transformed = this.transformer.apply((Pair<String, ModuleInstance>)new Pair((Object)this.value, (Object)this.instance));
            return StatResolver.resolveDouble(transformed, this.instance);
        }

        public static AttributeModifier.Operation getOperation(String operationString) {
            return switch (operationString) {
                case "*" -> AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
                case "**" -> AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
                default -> AttributeModifier.Operation.ADD_VALUE;
            };
        }

        private static String toCodecString(AttributeModifier.Operation operation) {
            return switch (operation) {
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> "*";
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> "**";
                default -> "+";
            };
        }
    }
}

