/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public abstract class EitherModuleProperty<T, K>
implements ModuleProperty<Either<T, K>> {
    protected final Codec<T> codec;

    protected EitherModuleProperty(Codec<T> codec) {
        this.codec = codec;
    }

    protected abstract K initializeDecode(T var1, ModuleInstance var2);

    protected abstract K mergeInterpreted(K var1, K var2, MergeType var3);

    protected abstract T mergeRaw(T var1, T var2, MergeType var3);

    protected abstract T deInitialize(K var1);

    public T decodeRaw(JsonElement element) {
        return (T)((Pair)this.codec.decode(this.getOps(), (Object)element).getOrThrow(s -> new DecoderException("could not decode CodecProperty " + this.getClass().getName() + " " + s))).getFirst();
    }

    @Override
    public JsonElement encode(Either<T, K> property) {
        Object data = property.right().isPresent() ? this.deInitialize(property.right().get()) : property.left().get();
        return (JsonElement)this.codec.encodeStart(this.getOps(), data).getOrThrow(s -> new DecoderException("could not encode CodecProperty " + this.getClass().getName() + " " + s));
    }

    public RegistryOps<JsonElement> getOps() {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
        if (Miapi.registryAccess != null) {
            ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Miapi.registryAccess);
        }
        return ops;
    }

    @Override
    public Either<T, K> decode(JsonElement element) {
        return Either.left(this.decodeRaw(element));
    }

    @Override
    public Either<T, K> initialize(Either<T, K> property, ModuleInstance context) {
        return Either.right(this.initializeDecode(property.left().get(), context));
    }

    @Override
    public Either<T, K> merge(Either<T, K> left, Either<T, K> right, MergeType mergeType) {
        if (left.left().isPresent()) {
            return Either.left(this.mergeRaw(left.left().get(), right.left().get(), mergeType));
        }
        return Either.right(this.mergeInterpreted(left.right().get(), right.right().get(), mergeType));
    }
}

