/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.InitializeAble;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public interface ModuleProperty<T>
extends MergeAble<T>,
InitializeAble<T> {
    public T decode(JsonElement var1);

    default public T decodeAndLoad(JsonElement element) {
        try {
            if (this.load(Miapi.id("runtime_load"), element, Platform.getEnv() == Dist.CLIENT)) {
                return this.decode(element);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public JsonElement encode(T var1);

    default public JsonElement encodeCast(Object property) {
        return this.encode(property);
    }

    default public JsonElement encodeCastAndLoad(Object property) {
        return this.encode(property);
    }

    default public T merge(T left, ModuleInstance leftModule, T right, ModuleInstance rightModule, MergeType mergeType) {
        return this.merge(left, right, mergeType);
    }

    default public boolean load(ResourceLocation id, JsonElement element, boolean isClient) throws Exception {
        this.decode(element);
        return true;
    }

    default public Optional<T> getData(ModuleInstance moduleInstance) {
        if (ReloadEvents.isInReload()) {
            return Optional.empty();
        }
        if (moduleInstance == null || moduleInstance.module == ItemModule.empty) {
            return Optional.empty();
        }
        return Optional.ofNullable(moduleInstance.getProperty(this));
    }

    default public Optional<T> getData(ItemStack itemStack) {
        if (itemStack == null) {
            return Optional.empty();
        }
        if (!ModularItem.isModularItem(itemStack)) {
            return Optional.empty();
        }
        if (ReloadEvents.isInReload()) {
            return Optional.empty();
        }
        ModuleInstance baseModule = ItemModule.getModules(itemStack);
        if (baseModule == null || baseModule.module == ItemModule.empty) {
            return Optional.empty();
        }
        return Optional.ofNullable(baseModule.getPropertyItemStack(this));
    }

    default public Optional<T> getData(ItemModule module) {
        return Optional.ofNullable(module.properties().get(this));
    }

    default public Optional<T> getData(Map<ModuleProperty<?>, Object> properties) {
        return Optional.ofNullable(properties.get(this));
    }

    @Override
    default public T initialize(T property, ModuleInstance context) {
        return property;
    }

    public static JsonObject mergedJsonObjects(JsonObject left, JsonObject right, MergeType mergeType) {
        if (mergeType.equals((Object)MergeType.OVERWRITE)) {
            return right;
        }
        return ModuleProperty.deepMergeJsonObjects(left, right);
    }

    public static JsonObject deepMergeJsonObjects(JsonObject jsonObject1, JsonObject jsonObject2) {
        for (String key : jsonObject2.keySet()) {
            JsonElement value2 = jsonObject2.get(key);
            if (jsonObject1.has(key)) {
                JsonElement value1 = jsonObject1.get(key);
                if (value1.isJsonObject() && value2.isJsonObject()) {
                    JsonObject mergedSubObject = ModuleProperty.deepMergeJsonObjects(value1.getAsJsonObject(), value2.getAsJsonObject());
                    jsonObject1.add(key, (JsonElement)mergedSubObject);
                    continue;
                }
                jsonObject1.add(key, value2);
                continue;
            }
            jsonObject1.add(key, value2);
        }
        return jsonObject1;
    }
}

