/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import smartin.miapi.Miapi;
import smartin.miapi.network.NetworkingImpl;

public class Networking {
    public static Map<String, Consumer<FriendlyByteBuf>> S2CPackets = new HashMap<String, Consumer<FriendlyByteBuf>>();
    public static Map<String, BiConsumer<FriendlyByteBuf, ServerPlayer>> C2SPackets = new HashMap<String, BiConsumer<FriendlyByteBuf, ServerPlayer>>();
    public static NetworkingImpl implementation;
    protected static NetworkingImpl.EventListener listener;

    protected Networking() {
    }

    public static void setImplementation(NetworkingImpl implementation) {
        if (Networking.implementation != null) {
            implementation.unsubscribe(listener);
        }
        Networking.implementation = implementation;
        implementation.subscribe(listener);
    }

    public static FriendlyByteBuf createBuffer() {
        return implementation.createBuffer();
    }

    public static void registerC2SPacket(String identifier, BiConsumer<FriendlyByteBuf, ServerPlayer> callback) {
        if (C2SPackets.get(identifier) != null) {
            Miapi.LOGGER.error("packet already exists with identifier " + identifier);
        }
        C2SPackets.put(identifier, callback);
    }

    public static void unRegisterC2SPacket(String identifier) {
        C2SPackets.remove(identifier);
    }

    public static void unRegisterS2CPacket(String identifier) {
        S2CPackets.remove(identifier);
    }

    public static void registerS2CPacket(String identifier, Consumer<FriendlyByteBuf> callbacks) {
        if (S2CPackets.get(identifier) != null) {
            Miapi.LOGGER.error("packet already exists with identifier " + identifier);
        }
        S2CPackets.put(identifier, callbacks);
    }

    public static void sendC2S(String packetIdentifier, FriendlyByteBuf buffer) {
        implementation.sendPacketToServer(packetIdentifier, buffer);
    }

    public static void sendS2C(String packetIdentifier, ServerPlayer player, FriendlyByteBuf buffer) {
        implementation.sendPacketToClient(packetIdentifier, player, buffer);
    }

    public static void sendS2C(String packetIdentifier, FriendlyByteBuf buffer) {
        if (Miapi.server == null) {
            Miapi.LOGGER.error("cant send packets before Server has fully started");
        }
        Miapi.server.getPlayerList().getPlayers().forEach(serverPlayer -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(buffer.copy());
            implementation.sendPacketToClient(packetIdentifier, (ServerPlayer)serverPlayer, buf);
        });
    }

    static {
        listener = (key, data, entity) -> {
            if (entity == null) {
                Consumer<FriendlyByteBuf> consumer = S2CPackets.get(key);
                if (consumer != null) {
                    consumer.accept(data);
                }
            } else {
                BiConsumer<FriendlyByteBuf, ServerPlayer> consumer = C2SPackets.get(key);
                if (consumer != null) {
                    consumer.accept(data, entity);
                }
            }
        };
    }
}

