/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public abstract class NetworkingImpl {
    protected static final List<EventListener> listeners = new ArrayList<EventListener>();

    protected NetworkingImpl() {
    }

    public abstract void sendPacketToServer(String var1, FriendlyByteBuf var2);

    public abstract void sendPacketToClient(String var1, ServerPlayer var2, FriendlyByteBuf var3);

    public void subscribe(EventListener listener) {
        listeners.add(listener);
    }

    public void unsubscribe(EventListener listener) {
        listeners.remove(listener);
    }

    public void trigger(String path, FriendlyByteBuf data, @Nullable ServerPlayer entity) {
        for (EventListener listener : listeners) {
            listener.onEvent(path, data, entity);
        }
    }

    public abstract FriendlyByteBuf createBuffer();

    public static interface EventListener {
        public void onEvent(String var1, FriendlyByteBuf var2, @Nullable ServerPlayer var3);
    }
}

