/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.redpxnda.nucleus.config.screen.widget.IntegerFieldWidget;
import com.redpxnda.nucleus.math.MathUtil;
import com.redpxnda.nucleus.util.Color;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_6382;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.glint.AlphaSlider;
import smartin.miapi.client.gui.crafting.crafter.glint.ColorGrid;
import smartin.miapi.client.gui.crafting.crafter.glint.HueSlider;

@Environment(value=EnvType.CLIENT)
public class ColorPickerWidget
extends InteractAbleWidget {
    public static final class_2960 TEXTURE = CraftingScreen.BACKGROUND_TEXTURE;
    protected final class_327 textRenderer;
    protected final Consumer<Color> onUpdate;
    protected final ColorGrid colorGrid;
    protected final HueSlider hueSlider;
    protected final AlphaSlider alphaSlider;
    protected Color hueColor = Color.RED.copy();
    protected Color color = Color.RED;
    protected final IntegerFieldWidget redField;
    protected final IntegerFieldWidget greenField;
    protected final IntegerFieldWidget blueField;
    protected final IntegerFieldWidget hueField;
    protected final IntegerFieldWidget satField;
    protected final IntegerFieldWidget lightField;
    protected final IntegerFieldWidget alphaField;

    public ColorPickerWidget(class_327 textR, int y, int x, Consumer<Color> updateListener) {
        super(x, y, 128, 92, (class_2561)class_2561.method_43473());
        this.textRenderer = textR;
        this.onUpdate = updateListener;
        this.colorGrid = new ColorGrid(x + 8, y + 8, 76, 76, c -> this.updateColor());
        this.hueSlider = new HueSlider(x + 20, y + 94, 64, 8, f -> this.updateHue());
        this.alphaSlider = new AlphaSlider(x + 20, y + 110, 64, 8, f -> this.updateAlpha());
        this.redField = new IntegerFieldWidget(textR, x + 101, y + 9, 30, 9, 0, 255, (class_2561)class_2561.method_43473(), i -> this.setColorAndUpdate(this.color.withRed(i.intValue())), "\u0280");
        this.greenField = new IntegerFieldWidget(textR, x + 101, y + 22, 30, 9, 0, 255, (class_2561)class_2561.method_43473(), i -> this.setColorAndUpdate(this.color.withGreen(i.intValue())), "\u0262");
        this.blueField = new IntegerFieldWidget(textR, x + 101, y + 35, 30, 9, 0, 255, (class_2561)class_2561.method_43473(), i -> this.setColorAndUpdate(this.color.withBlue(i.intValue())), "\u0299");
        this.hueField = new IntegerFieldWidget(textR, x + 101, y + 50, 30, 9, 0, 360, (class_2561)class_2561.method_43473(), i -> this.setColorAndUpdate((float)i.intValue() / 360.0f, this.colorGrid.saturation, this.colorGrid.lightness), "\u029c");
        this.satField = new IntegerFieldWidget(textR, x + 101, y + 63, 30, 9, 0, 100, (class_2561)class_2561.method_43473(), i -> this.setColorAndUpdate(this.hueSlider.value, (float)i.intValue() / 100.0f, this.colorGrid.lightness), "\u0455");
        this.lightField = new IntegerFieldWidget(textR, x + 101, y + 76, 30, 9, 0, 100, (class_2561)class_2561.method_43473(), i -> this.setColorAndUpdate(this.hueSlider.value, this.colorGrid.saturation, (float)i.intValue() / 100.0f), "\u029f");
        this.alphaField = new IntegerFieldWidget(textR, x + 101, y + 108, 30, 9, 0, 100, (class_2561)class_2561.method_43473(), i -> this.setColorAndUpdate(this.color.withAlpha((float)i.intValue() / 100.0f)), "\u1d00");
    }

    public ColorPickerWidget(class_327 textRenderer, int x, int y, Consumer<Color> onUpdate, ColorGrid ColorGrid2, HueSlider hueSlider, AlphaSlider alphaSlider, IntegerFieldWidget redField, IntegerFieldWidget greenField, IntegerFieldWidget blueField, IntegerFieldWidget hueField, IntegerFieldWidget satField, IntegerFieldWidget lightField, IntegerFieldWidget alphaField) {
        super(x, y, 128, 128, (class_2561)class_2561.method_43473());
        this.textRenderer = textRenderer;
        this.onUpdate = onUpdate;
        this.colorGrid = ColorGrid2;
        this.hueSlider = hueSlider;
        this.alphaSlider = alphaSlider;
        this.redField = redField;
        this.greenField = greenField;
        this.blueField = blueField;
        this.hueField = hueField;
        this.satField = satField;
        this.lightField = lightField;
        this.alphaField = alphaField;
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.colorGrid.method_46421(x + 8);
        this.hueSlider.method_46421(x + 20);
        this.alphaSlider.method_46421(x + 20);
        this.redField.method_46421(x + 101);
        this.greenField.method_46421(x + 101);
        this.blueField.method_46421(x + 101);
        this.hueField.method_46421(x + 101);
        this.satField.method_46421(x + 101);
        this.lightField.method_46421(x + 101);
        this.alphaField.method_46421(x + 101);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.colorGrid.method_46419(y + 8);
        this.hueSlider.method_46419(y + 94);
        this.alphaSlider.method_46419(y + 110);
        this.redField.method_46419(y + 9);
        this.greenField.method_46419(y + 22);
        this.blueField.method_46419(y + 35);
        this.hueField.method_46419(y + 50);
        this.satField.method_46419(y + 63);
        this.lightField.method_46419(y + 76);
        this.alphaField.method_46419(y + 108);
    }

    public void setTextFieldValues() {
        this.redField.setValue(this.color.r());
        this.greenField.setValue(this.color.g());
        this.blueField.setValue(this.color.b());
        this.hueField.setValue(Math.round(this.hueSlider.value * 360.0f));
        this.satField.setValue(Math.round(this.colorGrid.saturation * 100.0f));
        this.lightField.setValue(Math.round(this.colorGrid.lightness * 100.0f));
        this.alphaField.setValue(Math.round(this.alphaSlider.value * 100.0f));
    }

    public void setColor(float hue, float saturation, float lightness) {
        this.hueSlider.value = MathUtil.method_15363((float)hue, (float)0.0f, (float)1.0f);
        this.colorGrid.saturation = MathUtil.method_15363((float)saturation, (float)0.0f, (float)1.0f);
        this.colorGrid.lightness = MathUtil.method_15363((float)lightness, (float)0.0f, (float)1.0f);
        this.updateHueNoUpdate();
        this.color = this.colorGrid.calculateColor();
        this.color.setAlpha(this.alphaSlider.value);
        this.setTextFieldValues();
    }

    public void setColorAndUpdate(float hue, float saturation, float lightness) {
        this.setColor(hue, saturation, lightness);
        this.onUpdate.accept(this.color);
    }

    public void setColor(Color clr) {
        float[] hsl = MathUtil.rgbToHsv((int)clr.r(), (int)clr.g(), (int)clr.b());
        this.color = clr;
        this.hueSlider.value = MathUtil.method_15363((float)(hsl[0] / 360.0f), (float)0.0f, (float)1.0f);
        this.alphaSlider.value = clr.alphaAsFloat();
        this.colorGrid.saturation = MathUtil.method_15363((float)hsl[1], (float)0.0f, (float)1.0f);
        this.colorGrid.lightness = MathUtil.method_15363((float)hsl[2], (float)0.0f, (float)1.0f);
        this.updateHueNoUpdate();
        this.colorGrid.calculateColor();
        this.setTextFieldValues();
    }

    public void setColorAndUpdate(Color clr) {
        this.setColor(clr);
        this.onUpdate.accept(this.color);
    }

    public void updateColor() {
        this.color = this.colorGrid.color.copy();
        this.color.setAlpha(this.alphaSlider.value);
        this.setTextFieldValues();
        this.onUpdate.accept(this.color);
    }

    public void updateAlpha() {
        this.color.setAlpha(this.alphaSlider.value);
        this.updateColor();
    }

    public void updateHueNoUpdate() {
        int len = Color.RAINBOW.length;
        float pos = this.hueSlider.value * (float)len;
        int index = (int)pos;
        float delta = pos - (float)index;
        Color left = Color.RAINBOW[index % len];
        Color right = Color.RAINBOW[(index + 1) % len];
        left.lerp(delta, right, this.hueColor);
        this.colorGrid.hueColor = this.hueColor;
    }

    public void updateHue() {
        this.updateHueNoUpdate();
        this.colorGrid.update();
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25291(TEXTURE, this.method_46426(), this.method_46427(), 0, 0.0f, 295.0f, 128, 92, 512, 512);
        this.colorGrid.method_25394(context, mouseX, mouseY, delta);
        this.redField.method_25394(context, mouseX, mouseY, delta);
        this.greenField.method_25394(context, mouseX, mouseY, delta);
        this.blueField.method_25394(context, mouseX, mouseY, delta);
        this.hueField.method_25394(context, mouseX, mouseY, delta);
        this.satField.method_25394(context, mouseX, mouseY, delta);
        this.lightField.method_25394(context, mouseX, mouseY, delta);
    }

    public void unfocusTextFields() {
        this.redField.method_25365(false);
        this.blueField.method_25365(false);
        this.greenField.method_25365(false);
        this.hueField.method_25365(false);
        this.satField.method_25365(false);
        this.lightField.method_25365(false);
        this.alphaField.method_25365(false);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.unfocusTextFields();
        if (this.colorGrid.method_25405(mouseX, mouseY) && this.colorGrid.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hueSlider.method_25405(mouseX, mouseY) && this.hueSlider.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.alphaSlider.method_25405(mouseX, mouseY) && this.alphaSlider.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.redField.method_25405(mouseX, mouseY)) {
            this.redField.method_25365(true);
            return this.redField.method_25402(mouseX, mouseY, button);
        }
        if (this.greenField.method_25405(mouseX, mouseY)) {
            this.greenField.method_25365(true);
            return this.greenField.method_25402(mouseX, mouseY, button);
        }
        if (this.blueField.method_25405(mouseX, mouseY)) {
            this.blueField.method_25365(true);
            return this.blueField.method_25402(mouseX, mouseY, button);
        }
        if (this.hueField.method_25405(mouseX, mouseY)) {
            this.hueField.method_25365(true);
            return this.hueField.method_25402(mouseX, mouseY, button);
        }
        if (this.satField.method_25405(mouseX, mouseY)) {
            this.satField.method_25365(true);
            return this.satField.method_25402(mouseX, mouseY, button);
        }
        if (this.lightField.method_25405(mouseX, mouseY)) {
            this.lightField.method_25365(true);
            return this.lightField.method_25402(mouseX, mouseY, button);
        }
        if (this.alphaField.method_25405(mouseX, mouseY)) {
            this.alphaField.method_25365(true);
            return this.alphaField.method_25402(mouseX, mouseY, button);
        }
        if (this.field_22763 && this.field_22764) {
            boolean bl;
            if (this.method_25351(button) && (bl = this.method_25361(mouseX, mouseY))) {
                this.method_25354(class_310.method_1551().method_1483());
                this.method_25348(mouseX, mouseY);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.colorGrid.isDragging(mouseX, mouseY) && this.colorGrid.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.hueSlider.isDragging(mouseX, mouseY) && this.hueSlider.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.alphaSlider.isDragging(mouseX, mouseY) && this.alphaSlider.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.colorGrid.isReleasing(mouseX, mouseY) && this.colorGrid.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hueSlider.isReleasing(mouseX, mouseY) && this.hueSlider.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (this.alphaSlider.isReleasing(mouseX, mouseY) && this.alphaSlider.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.redField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.greenField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.blueField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.hueField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.satField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.lightField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.alphaField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        if (this.redField.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.greenField.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.blueField.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.hueField.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.satField.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.lightField.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.alphaField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    @Override
    protected void method_47399(class_6382 builder) {
    }
}

