/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.gui.BoxList;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.statdisplay.AttributeSingleDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.ComplexBooleanStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.DpsStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.MiningPropertyStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SinglePropertyStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.FireProof;
import smartin.miapi.modules.properties.LuminousLearningProperty;
import smartin.miapi.modules.properties.armor.CanWalkOnSnow;
import smartin.miapi.modules.properties.armor.ExhaustionProperty;
import smartin.miapi.modules.properties.armor.IsPiglinGold;
import smartin.miapi.modules.properties.armor.PillagesGuard;
import smartin.miapi.modules.properties.armor.StepCancelingProperty;
import smartin.miapi.modules.properties.armor.WaterGravityProperty;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.onHit.ArmorPenProperty;
import smartin.miapi.modules.properties.onHit.FracturingProperty;
import smartin.miapi.modules.properties.onHit.HealthPercentDamage;
import smartin.miapi.modules.properties.onHit.ImmolateProperty;
import smartin.miapi.modules.properties.onHit.LeechingProperty;
import smartin.miapi.modules.properties.onHit.NemesisProperty;
import smartin.miapi.modules.properties.onHit.SlashingProperty;
import smartin.miapi.modules.properties.onHit.entity.AquaticDamage;
import smartin.miapi.modules.properties.onHit.entity.IllagerBane;
import smartin.miapi.modules.properties.onHit.entity.SmiteDamage;
import smartin.miapi.modules.properties.onHit.entity.SpiderDamage;
import smartin.miapi.modules.properties.projectile.DrawTimeProperty;
import smartin.miapi.modules.properties.projectile.IsCrossbowShootAble;
import smartin.miapi.modules.properties.projectile.MakesImpactSoundProperty;
import smartin.miapi.modules.properties.projectile.RapidfireCrossbowProperty;
import smartin.miapi.modules.properties.projectile.WaterDragProperty;
import smartin.miapi.modules.properties.util.GuiWidgetSupplier;
import smartin.miapi.registries.RegistryInventory;

@Environment(value=EnvType.CLIENT)
public class StatListWidget
extends InteractAbleWidget {
    private static final List<InteractAbleWidget> statDisplays = new ArrayList<InteractAbleWidget>();
    private static final List<StatWidgetSupplier> statWidgetSupplier = new ArrayList<StatWidgetSupplier>();
    public static final Map<String, JsonConverter> jsonConverterMap = new HashMap<String, JsonConverter>();
    private final BoxList boxList;
    private final TransformableWidget transformableWidget;
    private final TransformableWidget hoverText;
    private class_1799 original = class_1799.field_8037;
    private class_1799 compareTo = class_1799.field_8037;

    public static void onReload() {
        statDisplays.clear();
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(NemesisProperty.property).setMin(0.0).setMax(1.0).setTranslationKey(NemesisProperty.KEY).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_5134.field_23721).setTranslationKey("minecraft.damage").setDefault(1.0).setMax(13.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_5134.field_23723).setTranslationKey("minecraft.attack_speed").setDefault(4.0).setMax(4.0).build());
        StatListWidget.addStatDisplay(new DpsStatDisplay());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.BACK_STAB).setTranslationKey("miapi.back_stab").setDefault(1.0).setFormat("##.#").setMax(5.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.SHIELD_BREAK).setTranslationKey("miapi.shield_break").setDefault(0.0).setFormat("##.#").setMax(5.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_5134.field_47758).setTranslationKey("minecraft.reach").setDefault(0.0).setFormat("##.##").setMax(2.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_5134.field_47759).setTranslationKey("minecraft.attack_range").setDefault(0.0).setFormat("##.##").setMax(2.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_DAMAGE).setTranslationKey("miapi.projectile_damage").setFormat("##.##").setDefault(0.0).setMax(10.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_SPEED).setTranslationKey("miapi.projectile_speed").setFormat("##.##").setDefault(0.0).setMin(-3.0).setMax(10.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_ACCURACY).setTranslationKey("miapi.projectile_accuracy").setFormat("##.##").setDefault(0.0).setMin(-2.0).setMax(2.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_PIERCING).setTranslationKey("miapi.projectile_piercing").setFormat("##.##").setMax(10.0).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(HealthPercentDamage.property).setMax(50.0).setHoverDescription(stack -> class_2561.method_43469((String)("miapi.stat." + String.valueOf(HealthPercentDamage.KEY) + ".description"), (Object[])new Object[]{new DecimalFormat("##.##").format(HealthPercentDamage.property.getValue(stack).orElse(0.0) / 100.0)})).setTranslationKey(HealthPercentDamage.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(ArmorPenProperty.property).setMin(-20.0).setMax(50.0).setTranslationKey(ArmorPenProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(SlashingProperty.property).setMin(-2.0).setMax(12.0).setTranslationKey(SlashingProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(WaterDragProperty.property).setMax(1.0).setTranslationKey(WaterDragProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(RapidfireCrossbowProperty.property).setMax(3.0).setFormat("##").setTranslationKey(RapidfireCrossbowProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(DurabilityProperty.property).setMax(2000.0).setFormat("##").setHoverFormat("##.##").setCondition((old, current) -> old.method_7963() && current.method_7963()).setTranslationKey(DurabilityProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(FracturingProperty.property).setMax(50.0).setTranslationKey(FracturingProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(ImmolateProperty.property).setMax(4.0).setTranslationKey(ImmolateProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(LeechingProperty.property).setMax(2.0).setTranslationKey(LeechingProperty.KEY).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_5134.field_23724).setTranslationKey("minecraft.armor").setMax(8.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_ARMOR).setTranslationKey("miapi.projectile_armor").setMax(8.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_5134.field_23725).setTranslationKey("minecraft.armor_toughness").setMax(3.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_5134.field_23718).setTranslationKey("minecraft.knockback_resistance").setMax(1.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.SWIM_SPEED).setTranslationKey("miapi.swim_speed").setMax(1.5).setDefault(1.0).setMin(0.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.ELYTRA_GLIDE_EFFICIENCY).setTranslationKey("miapi.elytra_glide").setMax(20.0).setMin(-20.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.ELYTRA_TURN_EFFICIENCY).setTranslationKey("miapi.elytra_turn").setMax(20.0).setMin(-20.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.ELYTRA_ROCKET_EFFICIENCY).setTranslationKey("miapi.rocket_efficiency").setMax(5.0).setMin(-5.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PLAYER_ITEM_USE_MOVEMENT_SPEED).setTranslationKey("miapi.player_item_use_speed").setMax(0.0).inverseNumber(true).setMin(-1.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.CRITICAL_DAMAGE).setTranslationKey("miapi.crit_damage").setMax(3.0).setMin(0.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.CRITICAL_CHANCE).setTranslationKey("miapi.crit_chance").setMax(1.0).setMin(0.0).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(DrawTimeProperty.property).setMax(2.5).setFormat("##.##").setInverse(true).setTranslationKey(DrawTimeProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(IllagerBane.property).setMax(3.0).setFormat("##.#").setTranslationKey(IllagerBane.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(LuminousLearningProperty.property).setMax(2.0).setFormat("##.#").setTranslationKey(LuminousLearningProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(ExhaustionProperty.property).setMax(50.0).setFormat("##.#").setTranslationKey(ExhaustionProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(WaterGravityProperty.property).setMax(100.0).setFormat("##.#").setTranslationKey(WaterGravityProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(AquaticDamage.property).setMax(5.0).setTranslationKey(AquaticDamage.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(SpiderDamage.property).setMax(5.0).setTranslationKey(SpiderDamage.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(SmiteDamage.property).setMax(5.0).setTranslationKey(SmiteDamage.KEY).build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(CanWalkOnSnow.property).setTranslationKey(CanWalkOnSnow.KEY).build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(FireProof.property).setTranslationKey(FireProof.KEY).build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(IsCrossbowShootAble.property).setTranslationKey(IsCrossbowShootAble.KEY).build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(IsPiglinGold.property).setTranslationKey(IsPiglinGold.KEY).build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(StepCancelingProperty.property).setTranslationKey(StepCancelingProperty.KEY).build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(MakesImpactSoundProperty.property).setTranslationKey(MakesImpactSoundProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(PillagesGuard.property).setMax(3.0).setFormat("##.#").setTranslationKey(PillagesGuard.KEY).setHoverDescription(stack -> {
            double value = PillagesGuard.valueRemap(PillagesGuard.property.getValue(stack).orElse(0.0));
            value = (double)Math.round((1.0 - value) * 1000.0) / 10.0;
            return class_2561.method_43469((String)"miapi.stat.pillagerGuard.description", (Object[])new Object[]{value});
        }).build());
        StatListWidget.addStatDisplay(new MiningPropertyStatDisplay("pickaxe"));
        StatListWidget.addStatDisplay(new MiningPropertyStatDisplay("shovel"));
        StatListWidget.addStatDisplay(new MiningPropertyStatDisplay("sword"));
        StatListWidget.addStatDisplay(new MiningPropertyStatDisplay("axe"));
        StatListWidget.addStatDisplay(new MiningPropertyStatDisplay("hoe"));
        AttributeSingleDisplay.attributesWithDisplay.add((class_1320)AttributeRegistry.ARMOR_CRUSHING.comp_349());
        RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.getFlatMap().values().stream().filter(StatWidgetSupplier.class::isInstance).map(StatWidgetSupplier.class::cast).filter(statWidgetSupplier::contains).forEach(statWidgetSupplier::add);
    }

    public static void reloadEnd() {
        class_7923.field_41190.forEach(entityAttribute -> {
            if (entityAttribute != null && !AttributeSingleDisplay.attributesWithDisplay.contains(entityAttribute)) {
                StatListWidget.addStatDisplay(AttributeSingleDisplay.builder((class_6880<class_1320>)class_7923.field_41190.method_47983(entityAttribute)).setDefault(0.0).build());
            }
        });
    }

    public StatListWidget(int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"miapi.module.statdisplay"));
        this.transformableWidget = new TransformableWidget(x, y, width, height, (class_2561)class_2561.method_43473());
        this.boxList = new BoxList(x, y, width, height, (class_2561)class_2561.method_43473(), new ArrayList<class_339>());
        ScrollList list = new ScrollList(x, y, width, height, List.of(this.boxList));
        list.altDesign = true;
        list.alwaysEnableScrollbar = true;
        this.transformableWidget.addChild(list);
        this.transformableWidget.rawProjection = new Matrix4f();
        this.addChild(this.transformableWidget);
        this.hoverText = new TransformableWidget(x, y, width, height, (class_2561)class_2561.method_43473());
        this.hoverText.rawProjection = new Matrix4f().scale(0.667f, 0.667f, 0.667f);
        this.addChild(this.hoverText);
    }

    public static class_5250 statTranslation(String statName) {
        return class_2561.method_43471((String)("miapi.stat." + statName));
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_48579(drawContext, mouseX, mouseY, delta);
        Vector4f vector4f = this.transformableWidget.transFormMousePos(mouseX, mouseY);
        InteractAbleWidget hoverDisplay = null;
        for (class_364 children : this.boxList.children()) {
            SingleStatDisplay widget;
            InteractAbleWidget ableWidget;
            if (!children.method_25405((double)vector4f.x(), (double)vector4f.y()) || !(children instanceof SingleStatDisplay) || (ableWidget = (widget = (SingleStatDisplay)children).getHoverWidget()) == null) continue;
            hoverDisplay = ableWidget;
        }
        if (hoverDisplay != null && this.method_25405(mouseX, mouseY)) {
            float scale = 1.0f;
            hoverDisplay.method_46421((int)((float)(mouseX + 5) * (1.0f / scale)));
            hoverDisplay.method_46419((int)(((float)mouseY - (float)(hoverDisplay.method_25364() / 2) * scale) * (1.0f / scale)));
            this.hoverText.renderWidget(hoverDisplay, drawContext, mouseX, mouseY, delta);
        }
    }

    private <T extends InteractAbleWidget> void update() {
        StatListWidget.setAttributeCaches(this.original, this.compareTo);
        this.boxList.setWidgets(StatListWidget.collectWidgets(this.original, this.compareTo), 0);
    }

    public static void setAttributeCaches(class_1799 original, class_1799 compareTo) {
        for (class_1304 equipmentSlot : class_1304.values()) {
            Multimap<class_1320, class_1322> oldAttr = AttributeUtil.getAttribute(original, equipmentSlot);
            Multimap<class_1320, class_1322> compAttr = AttributeUtil.getAttribute(compareTo, equipmentSlot);
            AttributeSingleDisplay.oldItemCache.put(equipmentSlot, oldAttr);
            AttributeSingleDisplay.compareItemCache.put(equipmentSlot, compAttr);
        }
    }

    public static <T extends InteractAbleWidget> List<InteractAbleWidget> collectWidgets(class_1799 original, class_1799 compareTo) {
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        for (StatWidgetSupplier supplier : statWidgetSupplier) {
            List statWidgets = supplier.currentList(original, compareTo);
            for (InteractAbleWidget statDisplay : statWidgets) {
                if (!((SingleStatDisplay)((Object)statDisplay)).shouldRender(original, compareTo)) continue;
                statDisplay.method_53533(((SingleStatDisplay)((Object)statDisplay)).getHeightDesired());
                statDisplay.method_25358(((SingleStatDisplay)((Object)statDisplay)).getWidthDesired());
                widgets.add(statDisplay);
            }
        }
        for (InteractAbleWidget statDisplay : statDisplays) {
            SingleStatDisplay singleStatDisplay;
            if (!(statDisplay instanceof SingleStatDisplay) || !(singleStatDisplay = (SingleStatDisplay)((Object)statDisplay)).shouldRender(original, compareTo)) continue;
            statDisplay.method_53533(singleStatDisplay.getHeightDesired());
            statDisplay.method_25358(singleStatDisplay.getWidthDesired());
            widgets.add(statDisplay);
        }
        ArrayList<InteractAbleWidget> sortedWidgets = new ArrayList<InteractAbleWidget>();
        int shortSize = 80;
        InteractAbleWidget buffered = null;
        for (InteractAbleWidget widget : widgets) {
            if (widget.method_25368() <= shortSize) {
                if (buffered == null) {
                    buffered = widget;
                    continue;
                }
                sortedWidgets.add(buffered);
                sortedWidgets.add(widget);
                buffered = null;
                continue;
            }
            sortedWidgets.add(widget);
        }
        if (buffered != null) {
            sortedWidgets.add(buffered);
        }
        return sortedWidgets;
    }

    public static <T extends InteractAbleWidget> void addStatDisplay(T statDisplay) {
        statDisplays.add(statDisplay);
    }

    public static <T extends InteractAbleWidget> void addStatDisplay(T ... statDisplay) {
        statDisplays.addAll(Arrays.asList(statDisplay));
    }

    public static void addStatDisplaySupplier(StatWidgetSupplier supplier) {
        statWidgetSupplier.add(supplier);
    }

    public void setOriginal(class_1799 original) {
        this.original = original;
        this.update();
    }

    public void setCompareTo(class_1799 compareTo) {
        this.compareTo = compareTo;
        this.update();
    }

    public void setItemsOriginal(class_1799 original, class_1799 compareTo) {
        this.original = original;
        this.compareTo = compareTo;
        this.update();
    }

    static {
        statWidgetSupplier.add(new StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(class_1799 original, class_1799 compareTo) {
                HashSet<GuiWidgetSupplier> suppliers = new HashSet<GuiWidgetSupplier>();
                suppliers.addAll(ItemModule.getModules((class_1799)original).itemMergedProperties.keySet().stream().filter(property -> property instanceof GuiWidgetSupplier).map(property -> (GuiWidgetSupplier)((Object)property)).toList());
                suppliers.addAll(ItemModule.getModules((class_1799)compareTo).itemMergedProperties.keySet().stream().filter(property -> property instanceof GuiWidgetSupplier).map(property -> (GuiWidgetSupplier)((Object)property)).toList());
                return suppliers.stream().map(guiWidgetSupplier -> new JsonStatDisplay(guiWidgetSupplier.getTitle(), guiWidgetSupplier.getDescription(), guiWidgetSupplier.getStatReader(), guiWidgetSupplier.getMinValue(), guiWidgetSupplier.getMaxValue())).toList();
            }
        });
    }

    public static interface TextGetter {
        public class_2561 resolve(class_1799 var1);
    }

    public static interface StatWidgetSupplier {
        public <T extends InteractAbleWidget> List<T> currentList(class_1799 var1, class_1799 var2);
    }

    public static interface JsonConverter<T extends InteractAbleWidget> {
        public T fromJson(JsonElement var1, SingleStatDisplayDouble.StatReaderHelper var2);
    }

    public static interface MultiTextGetter {
        public List<class_2561> resolve(class_1799 var1);
    }
}

