/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.craft.stat;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import com.redpxnda.nucleus.util.PriorityMap;
import com.redpxnda.nucleus.util.PriorityMultiMap;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.craft.stat.CraftingStat;

public interface StatActorType {
    public static final PriorityMap<StatActorType> TYPES = new PriorityMap();
    public static final BiMap<String, StatActorType> REGISTERED = HashBiMap.create();
    public static final PrioritizedEvent<ActorTypeCollectionEvent> EVENT = PrioritizedEvent.createLoop((Object[])new ActorTypeCollectionEvent[0]);
    public static final StatActorType ANCHOR = new StatActorType(){

        @Override
        public <T> T perform(CraftingStat<T> stat, Collection<T> actors, @Nullable T previous) {
            Object current = null;
            for (T newInstance : actors) {
                if (current == null) {
                    current = newInstance;
                    continue;
                }
                current = stat.getBetter(current, newInstance);
            }
            return previous == null ? current : stat.add(previous, current);
        }
    };
    public static final StatActorType ADD = new StatActorType(){

        @Override
        public <T> T perform(CraftingStat<T> stat, Collection<T> actors, @Nullable T previous) {
            Object current = null;
            for (T newInstance : actors) {
                if (current == null) {
                    current = newInstance;
                    continue;
                }
                current = stat.add(current, newInstance);
            }
            return previous == null ? current : stat.add(previous, current);
        }
    };
    public static final StatActorType MULTIPLY = new StatActorType(){

        @Override
        public <T> T perform(CraftingStat<T> stat, Collection<T> actors, @Nullable T previous) {
            if (previous == null) {
                return null;
            }
            Object current = null;
            for (T newInstance : actors) {
                if (current == null) {
                    current = newInstance;
                    continue;
                }
                current = stat.add(current, newInstance);
            }
            return stat.multiply(previous, current);
        }
    };

    public static void setup() {
        EVENT.register(rg -> {
            rg.register("anchor", ANCHOR, 0.0f);
            rg.register("add", ADD, 5.0f);
            rg.register("multiply", MULTIPLY, 10.0f);
        });
        LifecycleEvent.SETUP.register(() -> ((ActorTypeCollectionEvent)EVENT.invoker()).registerAll((str, type, prio) -> {
            REGISTERED.put((Object)str, (Object)type);
            TYPES.put((Object)type, (Object)Float.valueOf(prio));
            TYPES.sort();
        }));
    }

    public static <T> T evaluate(CraftingStat<T> stat, Map<StatActorType, PriorityMultiMap<T>> instances) {
        Object previous = null;
        for (StatActorType type : TYPES.keySet()) {
            PriorityMultiMap<T> map = instances.get(type);
            if (map == null) continue;
            previous = type.perform(stat, (Collection<T>)map.keys(), previous);
        }
        return previous == null ? stat.getDefault() : previous;
    }

    public <T> T perform(CraftingStat<T> var1, Collection<T> var2, @Nullable T var3);

    public static interface ActorTypeCollectionEvent {
        public void registerAll(Registerer var1);
    }

    public static interface Registerer {
        default public void register(String key, StatActorType type) {
            this.register(key, type, 0.0f);
        }

        public void register(String var1, StatActorType var2, float var3);
    }
}

